##
# @file tts_device.tcl
#
# @brief Microprocessor Driver Definition (MDD) Data Generation file for Device TTS interface
#
# @copy 2023 AIT Austrian Institute of Technology

##
# @brief DRC Secttion
#
# @param[in] drv_handle driver handle
proc drc_proc {drv_handle} {
    set periph [::hsm::utils::get_common_driver_ips $drv_handle]

    # Interface handler
    set clkif_50  [get_pins clk_i -of_objects $periph]

    # check connection status
    if {[get_property IS_CONNECTED $clkif_50] != 1} {
        error "The clock \"clk_i\" is not connected! Please connect it to a 50 MHz clock source!"
    }

    # check clock frequency
    set clkfq_50 [get_property CLK_FREQ $clkif_50]

    if {($clkfq_50 < 49500000) || ($clkfq_50 >= 50500000)} {
        error "The clock \"clk_i\" is not connected to 50 MHz clock source! ($clkfq_50)"
    }
}

##
# @brief Generation Section
proc generate {drv_handle} {
    # get TTS core clock (50MHz) frequency
    set periph   [::hsm::utils::get_common_driver_ips $drv_handle]
    set clkif_50 [get_pins clk_i -of_objects $periph]
    set clkfq_50 [get_property CLK_FREQ $clkif_50]

    # update xparameters.h with TTS device core clock frequency
    set fh [::hsi::utils::open_include_file "xparameters.h"]
    puts $fh "\n#define XPAR_TTS_DEVICE_CORE_CLK_FREQ $clkfq_50\n"
    close $fh

    # put some generic defines into xparameters.h
    ::hsi::utils::define_include_file $drv_handle "xparameters.h" "TTS_DEVICE" "NUM_INSTANCES" "DEVICE_ID" "C_BASEADDR" "C_HIGHADDR"
    ::hsi::utils::define_canonical_xpars $drv_handle "xparameters.h" "TTS_DEVICE" "DEVICE_ID" "C_BASEADDR" "C_HIGHADDR"
}
