/**
 * @file ltpll.h
 * @brief AIT Line Trigger PLL
 *
 * @author AIT
 * @copyright &copy;2023 Austrian Institute of Technology (AIT)
 */

#pragma once
#ifndef LTPLL_H
#define LTPLL_H

#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */

#include <stdint.h>

/**
 * AIT Line-Trigger PLL Register Layout
 */
struct LTPLLRegisterFile {
    uint32_t divider_1;                                 /**< 0x00 */
    uint32_t divider_2;                                 /**< 0x04 */
    uint32_t divider_3;                                 /**< 0x08 */
    uint32_t ki_clk_d20;                                /**< 0x0C */
    uint32_t kp;                                        /**< 0x10 */
    uint32_t max_linetrigger;                           /**< 0x14 */
    uint32_t min_linetrigger;                           /**< 0x18 */
    uint32_t system_frequency;                          /**< 0x1C */
    uint32_t output_high_length;                        /**< 0x20 */
    uint32_t test_counter;                              /**< 0x24 */
    uint32_t filter_reset:1;                            /**< 0x28 */
    uint32_t test_clk_in_en:1;
    uint32_t test_clk_out_en:1;
    uint32_t in_to_out_en:1;
    uint32_t puls_control_res:1;
    uint32_t pll_out_enable:1;
    uint32_t :28;
    uint32_t filter_out;                                /**< 0x2C */
    uint32_t pulse_control;                             /**< 0x30 */
} __attribute__ ((packed)) __attribute__ ((aligned(4)));

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* LTPLL_H */
