/**
 * @file tts_device.h
 * @brief CDI2 Device TTS logic interface
 *
 * @author AIT
 * @copyright &copy;2023 Austrian Institute of Technology (AIT)
 */

#pragma once
#ifndef TTS_DEVICE_H
#define TTS_DEVICE_H

#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */

#include <stdint.h>

#define kMaxTtsChannelCount       9                     /**< Number of TTS channels instantiated in the FPGA design */
#define kDefaultBpWidth           1500                  /**< BP pulse width in TC periods */
#define kTransportClockResolution 1                     /**< TC resolution in [10 ticks/mm] */
#define kDefaultResetPulseLength  20                    /**< CDI2 TTS RESET pulse length [ms] */

/**
 * CDI2 TTS Logic Register Layout
 */
struct TTSRegisterFile {
    uint32_t tccnt_sync;                                /**< 0x000 */
    uint32_t tccnt_load;                                /**< 0x004 */
    uint32_t trigger_source:1;                          /**< 0x008 */
    uint32_t trigger_enable:1;
    uint32_t :30;
    uint32_t inttrig_start;                             /**< 0x00C */
    uint32_t inttrig_number;                            /**< 0x010 */
    uint32_t inttrig_distance;                          /**< 0x014 */
    uint32_t inttrig_busy;                              /**< 0x018 */
    uint32_t tccnt_val;                                 /**< 0x01C */
    uint32_t tcperiod_actual;                           /**< 0x020 */
    uint32_t sync_clear_fifo;                           /**< 0x024 */
    struct TTS_Channel {                                /**< 0x028 */
        uint32_t bp_enable:1;
        uint32_t tc_enable:1;
        uint32_t tc_select:2;
        uint32_t tc_trigMode:1;
        uint32_t :27;
        uint32_t bptrig_update;
        uint32_t bp_pulsewidth;
        uint32_t reset_out;
        uint32_t ready_in;
    } ttsChannel[kMaxTtsChannelCount];
    uint32_t irq_enable;                                /**< 0x0DC */
    uint32_t irq_clear;                                 /**< 0x0EC */
    uint32_t irq_pending;                               /**< 0x0E4 */
    uint32_t irq_set;                                   /**< 0x0E8 */
    uint32_t hpsdebug_out;                              /**< 0x0EC */
    uint32_t tccnt_val_trig;                            /**< 0x0F0 */
    uint32_t tccnt_val_timerpulse;                      /**< 0x0F4 */
    uint32_t ttstc_period;                              /**< 0x0F8 */
    uint32_t ttsbp_period;                              /**< 0x0FC */
    uint32_t ttsbp_duration;                            /**< 0x100 */
    uint32_t ttsbp_numbers;                             /**< 0x104 */
    uint32_t ttsifc_status;                             /**< 0x108 */
    uint32_t testmode;                                  /**< 0x10C */
    uint32_t led_out;                                   /**< 0x110 */
    uint32_t speaker_ena;                               /**< 0x114 */
    uint32_t switch_status;                             /**< 0x118 */
    uint32_t ttsready_device;                           /**< 0x11C */
    uint32_t hpsdebug_dir;                              /**< 0x120 */
    uint32_t hpsdebug_in;                               /**< 0x124 */
    uint32_t global_sync_o;                             /**< 0x128 */
    uint32_t global_sync_d;                             /**< 0x12C */
    uint32_t global_sync_i;                             /**< 0x130 */
    uint32_t fast_sync_o;                               /**< 0x134 */
    uint32_t fast_sync_i;                               /**< 0x138 */
    uint32_t speaker_period;                            /**< 0x13C */
    uint32_t tx_injecterror_distance;                   /**< 0x140 */
    uint32_t tx_injecterror_numbers;                    /**< 0x144 */
    uint32_t rx_injecterror_distance;                   /**< 0x148 */
    uint32_t rx_injecterror_numbers;                    /**< 0x14C */
    uint32_t trigger_i;                                 /**< 0x150 */
    uint32_t hpsdebugout_select;                        /**< 0x154 */
    uint32_t soc_tcnt;                                  /**< 0x158 */
    uint32_t nc[5];
    uint32_t bptime_aftersoc;                           /**< 0x16C */
} __attribute__ ((packed)) __attribute__ ((aligned(4)));

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* TTS_DEVICE_H */
