#ifndef XPARAMETERS_H   /* prevent circular inclusions */
#define XPARAMETERS_H   /* by using protection macros */

/* Definitions for bus frequencies */
#define XPAR_CPU_M_AXI_DP_FREQ_HZ 100000000
/******************************************************************/

/* Canonical definitions for bus frequencies */
/******************************************************************/

#define XPAR_CPU_CORE_CLOCK_FREQ_HZ 100000000
#define XPAR_MICROBLAZE_CORE_CLOCK_FREQ_HZ 100000000

/******************************************************************/


/* Definitions for peripheral SOFTCORE */
#define XPAR_SOFTCORE_ADDR_SIZE 32
#define XPAR_SOFTCORE_ADDR_TAG_BITS 17
#define XPAR_SOFTCORE_ALLOW_DCACHE_WR 1
#define XPAR_SOFTCORE_ALLOW_ICACHE_WR 1
#define XPAR_SOFTCORE_AREA_OPTIMIZED 0
#define XPAR_SOFTCORE_ASYNC_INTERRUPT 1
#define XPAR_SOFTCORE_ASYNC_WAKEUP 3
#define XPAR_SOFTCORE_AVOID_PRIMITIVES 0
#define XPAR_SOFTCORE_BASE_VECTORS 0x0000000000000000
#define XPAR_SOFTCORE_BRANCH_TARGET_CACHE_SIZE 0
#define XPAR_SOFTCORE_CACHE_BYTE_SIZE 8192
#define XPAR_SOFTCORE_DADDR_SIZE 32
#define XPAR_SOFTCORE_DATA_SIZE 32
#define XPAR_SOFTCORE_DCACHE_ADDR_TAG 17
#define XPAR_SOFTCORE_DCACHE_ALWAYS_USED 1
#define XPAR_SOFTCORE_DCACHE_BASEADDR 0x00000000
#define XPAR_SOFTCORE_DCACHE_BYTE_SIZE 8192
#define XPAR_SOFTCORE_DCACHE_DATA_WIDTH 0
#define XPAR_SOFTCORE_DCACHE_FORCE_TAG_LUTRAM 0
#define XPAR_SOFTCORE_DCACHE_HIGHADDR 0x3FFFFFFF
#define XPAR_SOFTCORE_DCACHE_LINE_LEN 4
#define XPAR_SOFTCORE_DCACHE_USE_WRITEBACK 0
#define XPAR_SOFTCORE_DCACHE_VICTIMS 0
#define XPAR_SOFTCORE_DC_AXI_MON 0
#define XPAR_SOFTCORE_DEBUG_COUNTER_WIDTH 32
#define XPAR_SOFTCORE_DEBUG_ENABLED 1
#define XPAR_SOFTCORE_DEBUG_EVENT_COUNTERS 5
#define XPAR_SOFTCORE_DEBUG_EXTERNAL_TRACE 0
#define XPAR_SOFTCORE_DEBUG_INTERFACE 0
#define XPAR_SOFTCORE_DEBUG_LATENCY_COUNTERS 1
#define XPAR_SOFTCORE_DEBUG_PROFILE_SIZE 0
#define XPAR_SOFTCORE_DEBUG_TRACE_ASYNC_RESET 0
#define XPAR_SOFTCORE_DEBUG_TRACE_SIZE 8192
#define XPAR_SOFTCORE_DIV_ZERO_EXCEPTION 0
#define XPAR_SOFTCORE_DP_AXI_MON 0
#define XPAR_SOFTCORE_DYNAMIC_BUS_SIZING 0
#define XPAR_SOFTCORE_D_AXI 1
#define XPAR_SOFTCORE_D_LMB 1
#define XPAR_SOFTCORE_D_LMB_MON 0
#define XPAR_SOFTCORE_D_LMB_PROTOCOL 0
#define XPAR_SOFTCORE_ECC_USE_CE_EXCEPTION 0
#define XPAR_SOFTCORE_EDGE_IS_POSITIVE 1
#define XPAR_SOFTCORE_ENABLE_DISCRETE_PORTS 0
#define XPAR_SOFTCORE_ENDIANNESS 1
#define XPAR_SOFTCORE_FAULT_TOLERANT 0
#define XPAR_SOFTCORE_FPU_EXCEPTION 0
#define XPAR_SOFTCORE_FREQ 100000000
#define XPAR_SOFTCORE_FSL_EXCEPTION 0
#define XPAR_SOFTCORE_FSL_LINKS 0
#define XPAR_SOFTCORE_IADDR_SIZE 32
#define XPAR_SOFTCORE_ICACHE_ALWAYS_USED 1
#define XPAR_SOFTCORE_ICACHE_BASEADDR 0x00000000
#define XPAR_SOFTCORE_ICACHE_DATA_WIDTH 0
#define XPAR_SOFTCORE_ICACHE_FORCE_TAG_LUTRAM 0
#define XPAR_SOFTCORE_ICACHE_HIGHADDR 0x3FFFFFFF
#define XPAR_SOFTCORE_ICACHE_LINE_LEN 4
#define XPAR_SOFTCORE_ICACHE_STREAMS 0
#define XPAR_SOFTCORE_ICACHE_VICTIMS 0
#define XPAR_SOFTCORE_IC_AXI_MON 0
#define XPAR_SOFTCORE_ILL_OPCODE_EXCEPTION 0
#define XPAR_SOFTCORE_IMPRECISE_EXCEPTIONS 0
#define XPAR_SOFTCORE_INSTR_SIZE 32
#define XPAR_SOFTCORE_INTERCONNECT 2
#define XPAR_SOFTCORE_INTERRUPT_IS_EDGE 0
#define XPAR_SOFTCORE_INTERRUPT_MON 0
#define XPAR_SOFTCORE_IP_AXI_MON 0
#define XPAR_SOFTCORE_I_AXI 0
#define XPAR_SOFTCORE_I_LMB 1
#define XPAR_SOFTCORE_I_LMB_MON 0
#define XPAR_SOFTCORE_I_LMB_PROTOCOL 0
#define XPAR_SOFTCORE_LMB_DATA_SIZE 32
#define XPAR_SOFTCORE_LOCKSTEP_MASTER 0
#define XPAR_SOFTCORE_LOCKSTEP_SELECT 0
#define XPAR_SOFTCORE_LOCKSTEP_SLAVE 0
#define XPAR_SOFTCORE_M0_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M0_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M1_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M1_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M2_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M2_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M3_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M3_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M4_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M4_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M5_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M5_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M6_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M6_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M7_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M7_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M8_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M8_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M9_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M9_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M10_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M10_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M11_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M11_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M12_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M12_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M13_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M13_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M14_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M14_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_M15_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_M15_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_MMU_DTLB_SIZE 4
#define XPAR_SOFTCORE_MMU_ITLB_SIZE 2
#define XPAR_SOFTCORE_MMU_PRIVILEGED_INSTR 0
#define XPAR_SOFTCORE_MMU_TLB_ACCESS 3
#define XPAR_SOFTCORE_MMU_ZONES 16
#define XPAR_SOFTCORE_M_AXI_DC_ADDR_WIDTH 32
#define XPAR_SOFTCORE_M_AXI_DC_ARUSER_WIDTH 5
#define XPAR_SOFTCORE_M_AXI_DC_AWUSER_WIDTH 5
#define XPAR_SOFTCORE_M_AXI_DC_BUSER_WIDTH 1
#define XPAR_SOFTCORE_M_AXI_DC_DATA_WIDTH 32
#define XPAR_SOFTCORE_M_AXI_DC_EXCLUSIVE_ACCESS 0
#define XPAR_SOFTCORE_M_AXI_DC_RUSER_WIDTH 1
#define XPAR_SOFTCORE_M_AXI_DC_THREAD_ID_WIDTH 1
#define XPAR_SOFTCORE_M_AXI_DC_USER_SIGNALS 0
#define XPAR_SOFTCORE_M_AXI_DC_USER_VALUE 31
#define XPAR_SOFTCORE_M_AXI_DC_WUSER_WIDTH 1
#define XPAR_SOFTCORE_M_AXI_DP_ADDR_WIDTH 32
#define XPAR_SOFTCORE_M_AXI_DP_DATA_WIDTH 32
#define XPAR_SOFTCORE_M_AXI_DP_EXCLUSIVE_ACCESS 0
#define XPAR_SOFTCORE_M_AXI_DP_THREAD_ID_WIDTH 1
#define XPAR_SOFTCORE_M_AXI_D_BUS_EXCEPTION 0
#define XPAR_SOFTCORE_M_AXI_IC_ADDR_WIDTH 32
#define XPAR_SOFTCORE_M_AXI_IC_ARUSER_WIDTH 5
#define XPAR_SOFTCORE_M_AXI_IC_AWUSER_WIDTH 5
#define XPAR_SOFTCORE_M_AXI_IC_BUSER_WIDTH 1
#define XPAR_SOFTCORE_M_AXI_IC_DATA_WIDTH 32
#define XPAR_SOFTCORE_M_AXI_IC_RUSER_WIDTH 1
#define XPAR_SOFTCORE_M_AXI_IC_THREAD_ID_WIDTH 1
#define XPAR_SOFTCORE_M_AXI_IC_USER_SIGNALS 0
#define XPAR_SOFTCORE_M_AXI_IC_USER_VALUE 31
#define XPAR_SOFTCORE_M_AXI_IC_WUSER_WIDTH 1
#define XPAR_SOFTCORE_M_AXI_IP_ADDR_WIDTH 32
#define XPAR_SOFTCORE_M_AXI_IP_DATA_WIDTH 32
#define XPAR_SOFTCORE_M_AXI_IP_THREAD_ID_WIDTH 1
#define XPAR_SOFTCORE_M_AXI_I_BUS_EXCEPTION 0
#define XPAR_SOFTCORE_NUMBER_OF_PC_BRK 2
#define XPAR_SOFTCORE_NUMBER_OF_RD_ADDR_BRK 2
#define XPAR_SOFTCORE_NUMBER_OF_WR_ADDR_BRK 2
#define XPAR_SOFTCORE_NUM_SYNC_FF_CLK 2
#define XPAR_SOFTCORE_NUM_SYNC_FF_CLK_DEBUG 2
#define XPAR_SOFTCORE_NUM_SYNC_FF_CLK_IRQ 1
#define XPAR_SOFTCORE_NUM_SYNC_FF_DBG_CLK 1
#define XPAR_SOFTCORE_NUM_SYNC_FF_DBG_TRACE_CLK 2
#define XPAR_SOFTCORE_OPCODE_0X0_ILLEGAL 0
#define XPAR_SOFTCORE_OPTIMIZATION 0
#define XPAR_SOFTCORE_PC_WIDTH 32
#define XPAR_SOFTCORE_PIADDR_SIZE 32
#define XPAR_SOFTCORE_PVR 0
#define XPAR_SOFTCORE_PVR_USER1 0x00
#define XPAR_SOFTCORE_PVR_USER2 0x00000000
#define XPAR_SOFTCORE_RESET_MSR 0x00000000
#define XPAR_SOFTCORE_RESET_MSR_BIP 0
#define XPAR_SOFTCORE_RESET_MSR_DCE 0
#define XPAR_SOFTCORE_RESET_MSR_EE 0
#define XPAR_SOFTCORE_RESET_MSR_EIP 0
#define XPAR_SOFTCORE_RESET_MSR_ICE 0
#define XPAR_SOFTCORE_RESET_MSR_IE 0
#define XPAR_SOFTCORE_S0_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S0_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S1_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S1_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S2_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S2_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S3_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S3_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S4_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S4_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S5_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S5_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S6_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S6_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S7_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S7_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S8_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S8_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S9_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S9_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S10_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S10_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S11_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S11_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S12_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S12_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S13_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S13_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S14_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S14_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_S15_AXIS_DATA_WIDTH 32
#define XPAR_SOFTCORE_S15_AXIS_PROTOCOL GENERIC
#define XPAR_SOFTCORE_SCO 0
#define XPAR_SOFTCORE_TEMPORAL_DEPTH 0
#define XPAR_SOFTCORE_TRACE 0
#define XPAR_SOFTCORE_UNALIGNED_EXCEPTIONS 0
#define XPAR_SOFTCORE_USE_BARREL 1
#define XPAR_SOFTCORE_USE_BRANCH_TARGET_CACHE 0
#define XPAR_SOFTCORE_USE_CONFIG_RESET 0
#define XPAR_SOFTCORE_USE_DCACHE 0
#define XPAR_SOFTCORE_USE_DIV 0
#define XPAR_SOFTCORE_USE_EXTENDED_FSL_INSTR 0
#define XPAR_SOFTCORE_USE_EXT_BRK 0
#define XPAR_SOFTCORE_USE_EXT_NM_BRK 0
#define XPAR_SOFTCORE_USE_FPU 0
#define XPAR_SOFTCORE_USE_HW_MUL 0
#define XPAR_SOFTCORE_USE_ICACHE 0
#define XPAR_SOFTCORE_USE_INTERRUPT 2
#define XPAR_SOFTCORE_USE_MMU 0
#define XPAR_SOFTCORE_USE_MSR_INSTR 1
#define XPAR_SOFTCORE_USE_NON_SECURE 0
#define XPAR_SOFTCORE_USE_PCMP_INSTR 0
#define XPAR_SOFTCORE_USE_REORDER_INSTR 1
#define XPAR_SOFTCORE_USE_STACK_PROTECTION 0
#define XPAR_SOFTCORE_COMPONENT_NAME CDI2_Device_SoftCore_0
#define XPAR_SOFTCORE_EDK_IPTYPE PROCESSOR
#define XPAR_SOFTCORE_EDK_SPECIAL microblaze
#define XPAR_SOFTCORE_G_TEMPLATE_LIST 0
#define XPAR_SOFTCORE_G_USE_EXCEPTIONS 0

/******************************************************************/

#define XPAR_CPU_ID 0
#define XPAR_MICROBLAZE_ID 0
#define XPAR_MICROBLAZE_ADDR_SIZE 32
#define XPAR_MICROBLAZE_ADDR_TAG_BITS 17
#define XPAR_MICROBLAZE_ALLOW_DCACHE_WR 1
#define XPAR_MICROBLAZE_ALLOW_ICACHE_WR 1
#define XPAR_MICROBLAZE_AREA_OPTIMIZED 0
#define XPAR_MICROBLAZE_ASYNC_INTERRUPT 1
#define XPAR_MICROBLAZE_ASYNC_WAKEUP 3
#define XPAR_MICROBLAZE_AVOID_PRIMITIVES 0
#define XPAR_MICROBLAZE_BASE_VECTORS 0x0000000000000000
#define XPAR_MICROBLAZE_BRANCH_TARGET_CACHE_SIZE 0
#define XPAR_MICROBLAZE_CACHE_BYTE_SIZE 8192
#define XPAR_MICROBLAZE_DADDR_SIZE 32
#define XPAR_MICROBLAZE_DATA_SIZE 32
#define XPAR_MICROBLAZE_DCACHE_ADDR_TAG 17
#define XPAR_MICROBLAZE_DCACHE_ALWAYS_USED 1
#define XPAR_MICROBLAZE_DCACHE_BASEADDR 0x00000000
#define XPAR_MICROBLAZE_DCACHE_BYTE_SIZE 8192
#define XPAR_MICROBLAZE_DCACHE_DATA_WIDTH 0
#define XPAR_MICROBLAZE_DCACHE_FORCE_TAG_LUTRAM 0
#define XPAR_MICROBLAZE_DCACHE_HIGHADDR 0x3FFFFFFF
#define XPAR_MICROBLAZE_DCACHE_LINE_LEN 4
#define XPAR_MICROBLAZE_DCACHE_USE_WRITEBACK 0
#define XPAR_MICROBLAZE_DCACHE_VICTIMS 0
#define XPAR_MICROBLAZE_DC_AXI_MON 0
#define XPAR_MICROBLAZE_DEBUG_COUNTER_WIDTH 32
#define XPAR_MICROBLAZE_DEBUG_ENABLED 1
#define XPAR_MICROBLAZE_DEBUG_EVENT_COUNTERS 5
#define XPAR_MICROBLAZE_DEBUG_EXTERNAL_TRACE 0
#define XPAR_MICROBLAZE_DEBUG_INTERFACE 0
#define XPAR_MICROBLAZE_DEBUG_LATENCY_COUNTERS 1
#define XPAR_MICROBLAZE_DEBUG_PROFILE_SIZE 0
#define XPAR_MICROBLAZE_DEBUG_TRACE_ASYNC_RESET 0
#define XPAR_MICROBLAZE_DEBUG_TRACE_SIZE 8192
#define XPAR_MICROBLAZE_DIV_ZERO_EXCEPTION 0
#define XPAR_MICROBLAZE_DP_AXI_MON 0
#define XPAR_MICROBLAZE_DYNAMIC_BUS_SIZING 0
#define XPAR_MICROBLAZE_D_AXI 1
#define XPAR_MICROBLAZE_D_LMB 1
#define XPAR_MICROBLAZE_D_LMB_MON 0
#define XPAR_MICROBLAZE_D_LMB_PROTOCOL 0
#define XPAR_MICROBLAZE_ECC_USE_CE_EXCEPTION 0
#define XPAR_MICROBLAZE_EDGE_IS_POSITIVE 1
#define XPAR_MICROBLAZE_ENABLE_DISCRETE_PORTS 0
#define XPAR_MICROBLAZE_ENDIANNESS 1
#define XPAR_MICROBLAZE_FAULT_TOLERANT 0
#define XPAR_MICROBLAZE_FPU_EXCEPTION 0
#define XPAR_MICROBLAZE_FREQ 100000000
#define XPAR_MICROBLAZE_FSL_EXCEPTION 0
#define XPAR_MICROBLAZE_FSL_LINKS 0
#define XPAR_MICROBLAZE_IADDR_SIZE 32
#define XPAR_MICROBLAZE_ICACHE_ALWAYS_USED 1
#define XPAR_MICROBLAZE_ICACHE_BASEADDR 0x00000000
#define XPAR_MICROBLAZE_ICACHE_DATA_WIDTH 0
#define XPAR_MICROBLAZE_ICACHE_FORCE_TAG_LUTRAM 0
#define XPAR_MICROBLAZE_ICACHE_HIGHADDR 0x3FFFFFFF
#define XPAR_MICROBLAZE_ICACHE_LINE_LEN 4
#define XPAR_MICROBLAZE_ICACHE_STREAMS 0
#define XPAR_MICROBLAZE_ICACHE_VICTIMS 0
#define XPAR_MICROBLAZE_IC_AXI_MON 0
#define XPAR_MICROBLAZE_ILL_OPCODE_EXCEPTION 0
#define XPAR_MICROBLAZE_IMPRECISE_EXCEPTIONS 0
#define XPAR_MICROBLAZE_INSTR_SIZE 32
#define XPAR_MICROBLAZE_INTERCONNECT 2
#define XPAR_MICROBLAZE_INTERRUPT_IS_EDGE 0
#define XPAR_MICROBLAZE_INTERRUPT_MON 0
#define XPAR_MICROBLAZE_IP_AXI_MON 0
#define XPAR_MICROBLAZE_I_AXI 0
#define XPAR_MICROBLAZE_I_LMB 1
#define XPAR_MICROBLAZE_I_LMB_MON 0
#define XPAR_MICROBLAZE_I_LMB_PROTOCOL 0
#define XPAR_MICROBLAZE_LMB_DATA_SIZE 32
#define XPAR_MICROBLAZE_LOCKSTEP_MASTER 0
#define XPAR_MICROBLAZE_LOCKSTEP_SELECT 0
#define XPAR_MICROBLAZE_LOCKSTEP_SLAVE 0
#define XPAR_MICROBLAZE_M0_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M0_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M1_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M1_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M2_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M2_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M3_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M3_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M4_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M4_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M5_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M5_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M6_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M6_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M7_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M7_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M8_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M8_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M9_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M9_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M10_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M10_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M11_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M11_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M12_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M12_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M13_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M13_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M14_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M14_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_M15_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M15_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_MMU_DTLB_SIZE 4
#define XPAR_MICROBLAZE_MMU_ITLB_SIZE 2
#define XPAR_MICROBLAZE_MMU_PRIVILEGED_INSTR 0
#define XPAR_MICROBLAZE_MMU_TLB_ACCESS 3
#define XPAR_MICROBLAZE_MMU_ZONES 16
#define XPAR_MICROBLAZE_M_AXI_DC_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DC_ARUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_DC_AWUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_DC_BUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DC_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DC_EXCLUSIVE_ACCESS 0
#define XPAR_MICROBLAZE_M_AXI_DC_RUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DC_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DC_USER_SIGNALS 0
#define XPAR_MICROBLAZE_M_AXI_DC_USER_VALUE 31
#define XPAR_MICROBLAZE_M_AXI_DC_WUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_DP_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DP_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_DP_EXCLUSIVE_ACCESS 0
#define XPAR_MICROBLAZE_M_AXI_DP_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_D_BUS_EXCEPTION 0
#define XPAR_MICROBLAZE_M_AXI_IC_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IC_ARUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_IC_AWUSER_WIDTH 5
#define XPAR_MICROBLAZE_M_AXI_IC_BUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IC_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IC_RUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IC_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IC_USER_SIGNALS 0
#define XPAR_MICROBLAZE_M_AXI_IC_USER_VALUE 31
#define XPAR_MICROBLAZE_M_AXI_IC_WUSER_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_IP_ADDR_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IP_DATA_WIDTH 32
#define XPAR_MICROBLAZE_M_AXI_IP_THREAD_ID_WIDTH 1
#define XPAR_MICROBLAZE_M_AXI_I_BUS_EXCEPTION 0
#define XPAR_MICROBLAZE_NUMBER_OF_PC_BRK 2
#define XPAR_MICROBLAZE_NUMBER_OF_RD_ADDR_BRK 2
#define XPAR_MICROBLAZE_NUMBER_OF_WR_ADDR_BRK 2
#define XPAR_MICROBLAZE_NUM_SYNC_FF_CLK 2
#define XPAR_MICROBLAZE_NUM_SYNC_FF_CLK_DEBUG 2
#define XPAR_MICROBLAZE_NUM_SYNC_FF_CLK_IRQ 1
#define XPAR_MICROBLAZE_NUM_SYNC_FF_DBG_CLK 1
#define XPAR_MICROBLAZE_NUM_SYNC_FF_DBG_TRACE_CLK 2
#define XPAR_MICROBLAZE_OPCODE_0X0_ILLEGAL 0
#define XPAR_MICROBLAZE_OPTIMIZATION 0
#define XPAR_MICROBLAZE_PC_WIDTH 32
#define XPAR_MICROBLAZE_PIADDR_SIZE 32
#define XPAR_MICROBLAZE_PVR 0
#define XPAR_MICROBLAZE_PVR_USER1 0x00
#define XPAR_MICROBLAZE_PVR_USER2 0x00000000
#define XPAR_MICROBLAZE_RESET_MSR 0x00000000
#define XPAR_MICROBLAZE_RESET_MSR_BIP 0
#define XPAR_MICROBLAZE_RESET_MSR_DCE 0
#define XPAR_MICROBLAZE_RESET_MSR_EE 0
#define XPAR_MICROBLAZE_RESET_MSR_EIP 0
#define XPAR_MICROBLAZE_RESET_MSR_ICE 0
#define XPAR_MICROBLAZE_RESET_MSR_IE 0
#define XPAR_MICROBLAZE_S0_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S0_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S1_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S1_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S2_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S2_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S3_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S3_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S4_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S4_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S5_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S5_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S6_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S6_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S7_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S7_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S8_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S8_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S9_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S9_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S10_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S10_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S11_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S11_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S12_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S12_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S13_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S13_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S14_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S14_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_S15_AXIS_DATA_WIDTH 32
#define XPAR_MICROBLAZE_S15_AXIS_PROTOCOL GENERIC
#define XPAR_MICROBLAZE_SCO 0
#define XPAR_MICROBLAZE_TEMPORAL_DEPTH 0
#define XPAR_MICROBLAZE_TRACE 0
#define XPAR_MICROBLAZE_UNALIGNED_EXCEPTIONS 0
#define XPAR_MICROBLAZE_USE_BARREL 1
#define XPAR_MICROBLAZE_USE_BRANCH_TARGET_CACHE 0
#define XPAR_MICROBLAZE_USE_CONFIG_RESET 0
#define XPAR_MICROBLAZE_USE_DCACHE 0
#define XPAR_MICROBLAZE_USE_DIV 0
#define XPAR_MICROBLAZE_USE_EXTENDED_FSL_INSTR 0
#define XPAR_MICROBLAZE_USE_EXT_BRK 0
#define XPAR_MICROBLAZE_USE_EXT_NM_BRK 0
#define XPAR_MICROBLAZE_USE_FPU 0
#define XPAR_MICROBLAZE_USE_HW_MUL 0
#define XPAR_MICROBLAZE_USE_ICACHE 0
#define XPAR_MICROBLAZE_USE_INTERRUPT 2
#define XPAR_MICROBLAZE_USE_MMU 0
#define XPAR_MICROBLAZE_USE_MSR_INSTR 1
#define XPAR_MICROBLAZE_USE_NON_SECURE 0
#define XPAR_MICROBLAZE_USE_PCMP_INSTR 0
#define XPAR_MICROBLAZE_USE_REORDER_INSTR 1
#define XPAR_MICROBLAZE_USE_STACK_PROTECTION 0
#define XPAR_MICROBLAZE_COMPONENT_NAME CDI2_Device_SoftCore_0
#define XPAR_MICROBLAZE_EDK_IPTYPE PROCESSOR
#define XPAR_MICROBLAZE_EDK_SPECIAL microblaze
#define XPAR_MICROBLAZE_G_TEMPLATE_LIST 0
#define XPAR_MICROBLAZE_G_USE_EXCEPTIONS 0

/******************************************************************/

/* Platform specific definitions */
#define PLATFORM_MB
 
/* Definition for xilinx interrupt wrapper support  */
#define XIL_INTERRUPT
 
/******************************************************************/
#define STDIN_BASEADDRESS 0x41400000
#define STDOUT_BASEADDRESS 0x41400000

/******************************************************************/

#define XPAR_XILTIMER_ENABLED
/* Definitions for driver BRAM */
#define XPAR_XBRAM_NUM_INSTANCES 2U

/* Definitions for peripheral LOCALMEMORY_DLMB_BRAM_IF_CNTLR */
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_DEVICE_ID 0U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_DATA_WIDTH 32U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_ECC 0U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_FAULT_INJECT 0U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_CE_FAILING_REGISTERS 0U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_UE_FAILING_REGISTERS 0U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_ECC_STATUS_REGISTERS 0U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_CE_COUNTER_WIDTH 0U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_ECC_ONOFF_REGISTER 0U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_ECC_ONOFF_RESET_VALUE 1U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_WRITE_ACCESS 2U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_BASEADDR 0x00000000U
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_HIGHADDR 0x0007FFFFU
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_S_AXI_CTRL_BASEADDR 0xFFFFFFFFU  
#define XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_S_AXI_CTRL_HIGHADDR 0xFFFFFFFFU  


/* Definitions for peripheral LOCALMEMORY_ILMB_BRAM_IF_CNTLR */
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_DEVICE_ID 1U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_DATA_WIDTH 32U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_ECC 0U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_FAULT_INJECT 0U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_CE_FAILING_REGISTERS 0U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_UE_FAILING_REGISTERS 0U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_ECC_STATUS_REGISTERS 0U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_CE_COUNTER_WIDTH 0U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_ECC_ONOFF_REGISTER 0U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_ECC_ONOFF_RESET_VALUE 1U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_WRITE_ACCESS 2U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_BASEADDR 0x00000000U
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_HIGHADDR 0x0007FFFFU
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_S_AXI_CTRL_BASEADDR 0xFFFFFFFFU  
#define XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_S_AXI_CTRL_HIGHADDR 0xFFFFFFFFU  


/******************************************************************/

/* Canonical definitions for peripheral LOCALMEMORY_DLMB_BRAM_IF_CNTLR */
#define XPAR_BRAM_0_DEVICE_ID XPAR_LOCALMEMORY_DLMB_BRAM_IF_CNTLR_DEVICE_ID
#define XPAR_BRAM_0_DATA_WIDTH 32U
#define XPAR_BRAM_0_ECC 0U
#define XPAR_BRAM_0_FAULT_INJECT 0U
#define XPAR_BRAM_0_CE_FAILING_REGISTERS 0U
#define XPAR_BRAM_0_UE_FAILING_REGISTERS 0U
#define XPAR_BRAM_0_ECC_STATUS_REGISTERS 0U
#define XPAR_BRAM_0_CE_COUNTER_WIDTH 0U
#define XPAR_BRAM_0_ECC_ONOFF_REGISTER 0U
#define XPAR_BRAM_0_ECC_ONOFF_RESET_VALUE 1U
#define XPAR_BRAM_0_WRITE_ACCESS 2U
#define XPAR_BRAM_0_BASEADDR 0x00000000U
#define XPAR_BRAM_0_HIGHADDR 0x0007FFFFU
#define XPAR_BRAM_0_CTRL_BASEADDR 0xFFFFFFFFU  
#define XPAR_BRAM_0_CTRL_HIGHADDR 0xFFFFFFFEU  
#define XPAR_DLMB_0_CNTLR_BASEADDR 0x00000000
#define XPAR_DLMB_0_CNTLR_HIGHADDR 0x0007FFFF
#define XPAR_DLMB_CNTLR_BASEADDR XPAR_DLMB_0_CNTLR_BASEADDR
#define XPAR_DLMB_CNTLR_HIGHADDR XPAR_DLMB_0_CNTLR_HIGHADDR

/* Canonical definitions for peripheral LOCALMEMORY_ILMB_BRAM_IF_CNTLR */
#define XPAR_BRAM_1_DEVICE_ID XPAR_LOCALMEMORY_ILMB_BRAM_IF_CNTLR_DEVICE_ID
#define XPAR_BRAM_1_DATA_WIDTH 32U
#define XPAR_BRAM_1_ECC 0U
#define XPAR_BRAM_1_FAULT_INJECT 0U
#define XPAR_BRAM_1_CE_FAILING_REGISTERS 0U
#define XPAR_BRAM_1_UE_FAILING_REGISTERS 0U
#define XPAR_BRAM_1_ECC_STATUS_REGISTERS 0U
#define XPAR_BRAM_1_CE_COUNTER_WIDTH 0U
#define XPAR_BRAM_1_ECC_ONOFF_REGISTER 0U
#define XPAR_BRAM_1_ECC_ONOFF_RESET_VALUE 1U
#define XPAR_BRAM_1_WRITE_ACCESS 2U
#define XPAR_BRAM_1_BASEADDR 0x00000000U
#define XPAR_BRAM_1_HIGHADDR 0x0007FFFFU
#define XPAR_BRAM_1_CTRL_BASEADDR 0xFFFFFFFFU  
#define XPAR_BRAM_1_CTRL_HIGHADDR 0xFFFFFFFEU  
#define XPAR_ILMB_0_CNTLR_BASEADDR 0x00000000
#define XPAR_ILMB_0_CNTLR_HIGHADDR 0x0007FFFF
#define XPAR_ILMB_CNTLR_BASEADDR XPAR_ILMB_0_CNTLR_BASEADDR
#define XPAR_ILMB_CNTLR_HIGHADDR XPAR_ILMB_0_CNTLR_HIGHADDR


/******************************************************************/

/* Definitions for driver GPIO */
#define XPAR_XGPIO_NUM_INSTANCES 1

/* Definitions for peripheral STATUSLED */
#define XPAR_STATUSLED_BASEADDR 0x40000000
#define XPAR_STATUSLED_HIGHADDR 0x4000FFFF
#define XPAR_STATUSLED_DEVICE_ID 0
#define XPAR_STATUSLED_INTERRUPT_PRESENT 0
#define XPAR_STATUSLED_IS_DUAL 0


/******************************************************************/

/* Canonical definitions for peripheral STATUSLED */
#define XPAR_GPIO_0_BASEADDR 0x40000000
#define XPAR_GPIO_0_HIGHADDR 0x4000FFFF
#define XPAR_GPIO_0_DEVICE_ID XPAR_STATUSLED_DEVICE_ID
#define XPAR_GPIO_0_INTERRUPT_PRESENT 0
#define XPAR_GPIO_0_IS_DUAL 0


/******************************************************************/

#define XPAR_INTC_MAX_NUM_INTR_INPUTS 9
#define XPAR_XINTC_HAS_IPR 1
#define XPAR_XINTC_HAS_SIE 1
#define XPAR_XINTC_HAS_CIE 1
#define XPAR_XINTC_HAS_IVR 1
/* Definitions for driver INTC */
#define XPAR_XINTC_NUM_INSTANCES 1

/* Definitions for peripheral INTERRUPTCONTROLLER */
#define XPAR_INTERRUPTCONTROLLER_DEVICE_ID 0
#define XPAR_INTERRUPTCONTROLLER_BASEADDR 0x41200000
#define XPAR_INTERRUPTCONTROLLER_HIGHADDR 0x4120FFFF
#define XPAR_INTERRUPTCONTROLLER_KIND_OF_INTR 0xFFFFFE01
#define XPAR_INTERRUPTCONTROLLER_HAS_FAST 1
#define XPAR_INTERRUPTCONTROLLER_IVAR_RESET_VALUE 0x0000000000000010
#define XPAR_INTERRUPTCONTROLLER_NUM_INTR_INPUTS 9
#define XPAR_INTERRUPTCONTROLLER_NUM_SW_INTR 0
#define XPAR_INTERRUPTCONTROLLER_ADDR_WIDTH 32


/******************************************************************/

#define XPAR_INTC_SINGLE_BASEADDR 0x41200000
#define XPAR_INTC_SINGLE_HIGHADDR 0x4120FFFF
#define XPAR_INTC_SINGLE_DEVICE_ID XPAR_INTERRUPTCONTROLLER_DEVICE_ID
#define XPAR_INTERRUPTCONTROLLER_TYPE 0U
#define XPAR_DEBUGMODULE_INTERRUPT_MASK 0X000001U
#define XPAR_INTERRUPTCONTROLLER_DEBUGMODULE_INTERRUPT_INTR 0U
#define XPAR_OPENMAC_MAC_IRQ_MASK 0X000002U
#define XPAR_INTERRUPTCONTROLLER_OPENMAC_MAC_IRQ_INTR 1U
#define XPAR_TICKTIMER_INTERRUPT_MASK 0X000004U
#define XPAR_INTERRUPTCONTROLLER_TICKTIMER_INTERRUPT_INTR 2U
#define XPAR_TTS_DEVICE_IRQ_O_MASK 0X000008U
#define XPAR_INTERRUPTCONTROLLER_TTS_DEVICE_IRQ_O_INTR 3U
#define XPAR_OPENMAC_TIMER_IRQ_MASK 0X000010U
#define XPAR_INTERRUPTCONTROLLER_OPENMAC_TIMER_IRQ_INTR 4U
#define XPAR_OPENMAC_TIMER_PULSE_IRQ_MASK 0X000020U
#define XPAR_INTERRUPTCONTROLLER_OPENMAC_TIMER_PULSE_IRQ_INTR 5U
#define XPAR_CDI2_UART_IP2INTC_IRPT_MASK 0X000040U
#define XPAR_INTERRUPTCONTROLLER_CDI2_UART_IP2INTC_IRPT_INTR 6U
#define XPAR_PPP_UART_IP2INTC_IRPT_MASK 0X000080U
#define XPAR_INTERRUPTCONTROLLER_PPP_UART_IP2INTC_IRPT_INTR 7U
#define XPAR_SLEEPTIMER_INTERRUPT_MASK 0X000100U
#define XPAR_INTERRUPTCONTROLLER_SLEEPTIMER_INTERRUPT_INTR 8U

/******************************************************************/

/* Canonical definitions for peripheral INTERRUPTCONTROLLER */
#define XPAR_INTC_0_DEVICE_ID XPAR_INTERRUPTCONTROLLER_DEVICE_ID
#define XPAR_INTC_0_BASEADDR 0x41200000U
#define XPAR_INTC_0_HIGHADDR 0x4120FFFFU
#define XPAR_INTC_0_KIND_OF_INTR 0xFFFFFE01U
#define XPAR_INTC_0_HAS_FAST 1U
#define XPAR_INTC_0_IVAR_RESET_VALUE 0x0000000000000010U
#define XPAR_INTC_0_NUM_INTR_INPUTS 9U
#define XPAR_INTC_0_NUM_SW_INTR 0U
#define XPAR_INTC_0_ADDR_WIDTH 32U
#define XPAR_INTC_0_INTC_TYPE 0U

#define XPAR_INTC_0_UARTLITE_0_VEC_ID XPAR_INTERRUPTCONTROLLER_DEBUGMODULE_INTERRUPT_INTR
#define XPAR_INTC_0_OPENMAC_0_MAC_IRQ_VEC_ID XPAR_INTERRUPTCONTROLLER_OPENMAC_MAC_IRQ_INTR
#define XPAR_INTC_0_TMRCTR_1_VEC_ID XPAR_INTERRUPTCONTROLLER_TICKTIMER_INTERRUPT_INTR
#define XPAR_INTC_0_TTS_DEVICE_0_VEC_ID XPAR_INTERRUPTCONTROLLER_TTS_DEVICE_IRQ_O_INTR
#define XPAR_INTC_0_OPENMAC_0_TIMER_IRQ_VEC_ID XPAR_INTERRUPTCONTROLLER_OPENMAC_TIMER_IRQ_INTR
#define XPAR_INTC_0_OPENMAC_0_TIMER_PULSE_IRQ_VEC_ID XPAR_INTERRUPTCONTROLLER_OPENMAC_TIMER_PULSE_IRQ_INTR
#define XPAR_INTC_0_UARTNS550_0_VEC_ID XPAR_INTERRUPTCONTROLLER_CDI2_UART_IP2INTC_IRPT_INTR
#define XPAR_INTC_0_UARTNS550_1_VEC_ID XPAR_INTERRUPTCONTROLLER_PPP_UART_IP2INTC_IRPT_INTR
#define XPAR_INTC_0_TMRCTR_0_VEC_ID XPAR_INTERRUPTCONTROLLER_SLEEPTIMER_INTERRUPT_INTR

/******************************************************************/

#define XPAR_AXI_INTC
/* Definitions for driver OPENMAC */
#define XPAR__NUM_INSTANCES 1

/* Definitions for peripheral OPENMAC */
#define XPAR_OPENMAC_DEVICE_ID 0
#define XPAR_OPENMAC_BASEADDR 0x44A90000
#define XPAR_OPENMAC_HIGHADDR 0x44A9FFFF


/******************************************************************/

/* Canonical definitions for peripheral OPENMAC */
#define XPAR_OPENMAC_0_DEVICE_ID XPAR_OPENMAC_DEVICE_ID
#define XPAR_OPENMAC_0_BASEADDR 0x44A90000
#define XPAR_OPENMAC_0_HIGHADDR 0x44A9FFFF


/******************************************************************/

/* Definitions for driver TMRCTR */
#define XPAR_XTMRCTR_NUM_INSTANCES 2U

/* Definitions for peripheral SLEEPTIMER */
#define XPAR_SLEEPTIMER_DEVICE_ID 0U
#define XPAR_SLEEPTIMER_BASEADDR 0x41C00000U
#define XPAR_SLEEPTIMER_HIGHADDR 0x41C0FFFFU
#define XPAR_SLEEPTIMER_CLOCK_FREQ_HZ 100000000U


/* Definitions for peripheral TICKTIMER */
#define XPAR_TICKTIMER_DEVICE_ID 1U
#define XPAR_TICKTIMER_BASEADDR 0x41C10000U
#define XPAR_TICKTIMER_HIGHADDR 0x41C1FFFFU
#define XPAR_TICKTIMER_CLOCK_FREQ_HZ 100000000U


/******************************************************************/

/* Canonical definitions for peripheral SLEEPTIMER */
#define XPAR_TMRCTR_0_DEVICE_ID 0U
#define XPAR_TMRCTR_0_BASEADDR 0x41C00000U
#define XPAR_TMRCTR_0_HIGHADDR 0x41C0FFFFU
#define XPAR_TMRCTR_0_CLOCK_FREQ_HZ XPAR_SLEEPTIMER_CLOCK_FREQ_HZ
/* Canonical definitions for peripheral TICKTIMER */
#define XPAR_TMRCTR_1_DEVICE_ID 1U
#define XPAR_TMRCTR_1_BASEADDR 0x41C10000U
#define XPAR_TMRCTR_1_HIGHADDR 0x41C1FFFFU
#define XPAR_TMRCTR_1_CLOCK_FREQ_HZ XPAR_TICKTIMER_CLOCK_FREQ_HZ

/******************************************************************/

#define XPAR_SLEEPTIMER_INTERRUPT (XPAR_INTERRUPTCONTROLLER_SLEEPTIMER_INTERRUPT_INTR + 0x2000U)
#define XPAR_SLEEPTIMER_INTR_PARENT 0x41200001U
#define XPAR_TICKTIMER_INTERRUPT (XPAR_INTERRUPTCONTROLLER_TICKTIMER_INTERRUPT_INTR + 0x2000U)
#define XPAR_TICKTIMER_INTR_PARENT 0x41200001U

#define XPAR_TTS_DEVICE_CORE_CLK_FREQ 50000000

/* Definitions for driver TTS_DEVICE */
#define XPAR_TTS_DEVICE_NUM_INSTANCES 1

/* Definitions for peripheral TTS_DEVICE */
#define XPAR_TTS_DEVICE_DEVICE_ID 0
#define XPAR_TTS_DEVICE_BASEADDR 0x44AB0000
#define XPAR_TTS_DEVICE_HIGHADDR 0x44ABFFFF


/******************************************************************/

/* Canonical definitions for peripheral TTS_DEVICE */
#define XPAR_TTS_DEVICE_0_DEVICE_ID XPAR_TTS_DEVICE_DEVICE_ID
#define XPAR_TTS_DEVICE_0_BASEADDR 0x44AB0000
#define XPAR_TTS_DEVICE_0_HIGHADDR 0x44ABFFFF


/******************************************************************/

/* Definitions for driver UARTLITE */
#define XPAR_XUARTLITE_NUM_INSTANCES 1U

/* Definitions for peripheral DEBUGMODULE */
#define XPAR_DEBUGMODULE_DEVICE_ID 0U
#define XPAR_DEBUGMODULE_BASEADDR 0x41400000U
#define XPAR_DEBUGMODULE_HIGHADDR 0x41400FFFU
#define XPAR_DEBUGMODULE_BAUDRATE 0U
#define XPAR_DEBUGMODULE_USE_PARITY 0U
#define XPAR_DEBUGMODULE_ODD_PARITY 0U
#define XPAR_DEBUGMODULE_DATA_BITS 0U

/* Canonical definitions for peripheral DEBUGMODULE */
#define XPAR_UARTLITE_0_DEVICE_ID 0U
#define XPAR_UARTLITE_0_BASEADDR 0x41400000U
#define XPAR_UARTLITE_0_HIGHADDR 0x41400FFFU
#define XPAR_UARTLITE_0_BAUDRATE 0U
#define XPAR_UARTLITE_0_USE_PARITY 0U
#define XPAR_UARTLITE_0_ODD_PARITY 0U
#define XPAR_UARTLITE_0_DATA_BITS 0U


/******************************************************************/
/* Definitions for driver UARTNS550 */
#define XPAR_XUARTNS550_NUM_INSTANCES 2U
#define XPAR_XUARTNS550_CLOCK_HZ 100000000U

/* Definitions for peripheral CDI2_UART */
#define XPAR_CDI2_UART_DEVICE_ID 0U
#define XPAR_CDI2_UART_BASEADDR 0x44A80000U
#define XPAR_CDI2_UART_HIGHADDR 0x44A8FFFFU
#define XPAR_CDI2_UART_CLOCK_FREQ_HZ 100000000U


/* Definitions for peripheral PPP_UART */
#define XPAR_PPP_UART_DEVICE_ID 1U
#define XPAR_PPP_UART_BASEADDR 0x44AA0000U
#define XPAR_PPP_UART_HIGHADDR 0x44AAFFFFU
#define XPAR_PPP_UART_CLOCK_FREQ_HZ 100000000U


/******************************************************************/

/* Canonical definitions for peripheral CDI2_UART */
#define XPAR_UARTNS550_0_DEVICE_ID 0U
#define XPAR_UARTNS550_0_BASEADDR 0x44A80000U
#define XPAR_UARTNS550_0_HIGHADDR 0x44A8FFFFU
#define XPAR_UARTNS550_0_CLOCK_FREQ_HZ XPAR_CDI2_UART_CLOCK_FREQ_HZ

/* Canonical definitions for peripheral PPP_UART */
#define XPAR_UARTNS550_1_DEVICE_ID 1U
#define XPAR_UARTNS550_1_BASEADDR 0x44AA0000U
#define XPAR_UARTNS550_1_HIGHADDR 0x44AAFFFFU
#define XPAR_UARTNS550_1_CLOCK_FREQ_HZ XPAR_PPP_UART_CLOCK_FREQ_HZ


/******************************************************************/

/* Definitions for driver WDTTB */
#define XPAR_XWDTTB_NUM_INSTANCES 1U

/* Definitions for peripheral WATCHDOG */
#define XPAR_WATCHDOG_DEVICE_ID 0U
#define XPAR_WATCHDOG_BASEADDR 0x41A00000U
#define XPAR_WATCHDOG_HIGHADDR 0x41A0FFFFU
#define XPAR_WATCHDOG_ENABLE_WINDOW_WDT 0U
#define XPAR_WATCHDOG_MAX_COUNT_WIDTH 0U
#define XPAR_WATCHDOG_SST_COUNT_WIDTH 0U
#define XPAR_WATCHDOG_IS_PL 1U

/* Canonical definitions for peripheral WATCHDOG */
#define XPAR_WDTTB_0_DEVICE_ID 0U
#define XPAR_WDTTB_0_BASEADDR 0x41A00000U
#define XPAR_WDTTB_0_HIGHADDR 0x41A0FFFFU
#define XPAR_WDTTB_0_ENABLE_WINDOW_WDT 0U
#define XPAR_WDTTB_0_MAX_COUNT_WIDTH 0U
#define XPAR_WDTTB_0_SST_COUNT_WIDTH 0U
#define XPAR_WDTTB_0_IS_PL 1U
#define XPAR_WDTTB_0_WDT_CLK_FREQ_HZ 0U


/******************************************************************/
#endif  /* end of protection macro */
