# Usage with Vitis IDE:
# In Vitis IDE create a Single Application Debug launch configuration,
# change the debug type to 'Attach to running target' and provide this 
# tcl script in 'Execute Script' option.
# Path of this script: /home/peter/Projects/Spectra/Mars_ZX2_ST3/Workspace/CDI2_Device_system/_ide/scripts/debugger_cdi2_device-default.tcl
# 
# 
# Usage with xsct:
# To debug using xsct, launch xsct and run below command
# source /home/peter/Projects/Spectra/Mars_ZX2_ST3/Workspace/CDI2_Device_system/_ide/scripts/debugger_cdi2_device-default.tcl
# 
connect -url tcp:127.0.0.1:3121
targets -set -nocase -filter {name =~"APU*"}
rst -system
after 3000
targets -set -filter {jtag_cable_name =~ "Platform Cable USB II 00001b34611701" && level==0 && jtag_device_ctx=="jsn-DLC10-00001b34611701-23727093-0"}
fpga -file /home/peter/Projects/Spectra/Mars_ZX2_ST3/Workspace/CDI2_Device/_ide/bitstream/Mars_ZX2_ST3.bit
targets -set -nocase -filter {name =~"APU*"}
loadhw -hw /home/peter/Projects/Spectra/Mars_ZX2_ST3/Workspace/Mars_ZX2_ST3/export/Mars_ZX2_ST3/hw/Mars_ZX2_ST3.xsa -mem-ranges [list {0x40000000 0xbfffffff}] -regs
configparams force-mem-access 1
targets -set -nocase -filter {name =~"APU*"}
source /home/peter/Projects/Spectra/Mars_ZX2_ST3/Workspace/CDI2_Device/_ide/psinit/ps7_init.tcl
ps7_init
ps7_post_config
configparams mdm-detect-bscan-mask 2
targets -set -nocase -filter {name =~ "*microblaze*#0" && bscan=="USER2" }
dow /home/peter/Projects/Spectra/Mars_ZX2_ST3/Workspace/CDI2_Device/Debug/CDI2_Device.elf
configparams force-mem-access 0
bpadd -addr &main
