/**
 * @file logging.c
 * @brief CDI2 Device logging
 *
 * @author AIT
 * @copyright &copy;2023 AIT Austrian Institute of Technology
 */

#include <stdbool.h>

#include <xparameters.h>
#include <xuartlite_l.h>

#include "logging.h"

/** define system log level */
unsigned int logLevel = 0;

/* this ensures that an externally visible function are emitted for inlines. This comforts the linker */
extern inline bool isEnabledFor(unsigned int level);

void
setLevel(unsigned int level)
{
    logLevel = level;
}

void
logAsync(const char *msg)
{
    /* sanity */
    if (msg == NULL)
        return;

    for (const char *p = msg; (*p != 0) && ((p - msg) < 16); p++)
        XUartLite_WriteReg(STDOUT_BASEADDRESS, XUL_TX_FIFO_OFFSET, *p);
}
