/**
 * @file wd.h
 * @brief Watchdog and reset handling
 *
 * @author AIT
 * @copyright &copy;2023 AIT Austrian Institute of Technology
 */

#pragma once
#ifndef WD_H
#define WD_H

#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */

/** processor reset types: fabric reload scheduled reset, or watchdog */
enum WdResetType {
    WD_INIT      = 0xc07dcafeU,     /**< fabric reload */
    WD_SCHEDULED = 0xdeadbeefU,     /**< scheduled reset (OK, intended) */
    WD_WATCHDOG  = 0x0000002AU      /**< unscheduled reset (bad) */
};

/** magic variable holding last reset cause */
extern volatile unsigned long wdResetType;

/** periodically kick Watchdog */
void wdKick(void);

/** stop kicking the Watchdog to force processor reset */
void wdReset(void);

/** disable/stop Watchdog */
void wdStop(void);

/**
 * setup Watchdog
 *
 * @return XST_SUCCESS if successful, otherwise any XST_* error code
 */
int wdSetup(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* WD_H */
