/**
 * @file pppIf.h
 * @brief PPP UART interface
 *
 * @author AIT
 * @copyright &copy;2023 Austrian Institute of Technology (AIT)
 */

#pragma once
#ifndef PPP_IF_H
#define PPP_IF_H

#ifdef __cplusplus
extern "C"
{
#endif  /* __cplusplus */

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

/**
 * forward an IP datagram to our PPP peer
 *
 * @param[in] pIpData IP datagram data
 * @param[in] len datagram length
 */
void pppIfFwdIP(uint8_t *pIpData, size_t len);

/**
 * The 16 character deep RX FIFO overruns after 128us. Unfortunately,
 * FreeRTOS/Microblaze does not support nested interrupts, so we poll the
 * UARTs at various points in the (expensive/long) PowerLink ISR
 */
void pppIfPollUartIsr(void);

/**
 * @brief setup the PPP UART interface
 *
 * @param[in] speed desired UART speed in [baud]
 *
 * @return XST_SUCCESS or error code
 */
int pppIfSetup(unsigned long speed);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PPP_IF_H */
