/**
 * @file fcs.h
 *
 * @brief PPP RFC 1662 16-bit FCS implementation
 * @author AIT
 * @copyright &copy;2023 Austrian Institute of Technology (AIT)
 */

#pragma once
#ifndef FCS_H
#define FCS_H

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

#include <stdbool.h>
#include <stdint.h>

#include "sbuf.h"

#define PPP_INITFCS16   0xffff      /**< Initial FCS value */
#define PPP_GOODFCS16   0xf0b8      /**< Good final FCS value */

/**
 * calculate incremental RFC 1662 FCS16 for a given input byte
 *
 * @param[in] b new input byte/octet
 * @param[in] fcs current FCS16
 * @return updated FCS16
 */
uint16_t fcs16Incr(uint8_t b, uint16_t fcs);

/**
 * calculate RFC 1662 FCS16 over a complete sbuf chain
 *
 * @param[in] pHead sbuf chain head
 * @param[in] totLen total length of sbuf chain
 * @return true, if result is PPP_GOODFCS16, false otherwise
 */
bool fcs16Check(struct sbuf *pHead, size_t totLen);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* FCS_H */
