/**
 * @file crc16.h
 *
 * @brief CCITT CRC16 implementation
 * @author AIT
 * @copyright &copy;2023 Austrian Institute of Technology (AIT)
 */

#pragma once
#ifndef CRC_16_H
#define CRC_16_H

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

#include <stdbool.h>
#include <stdint.h>

#include "sbuf.h"

/** CCITT CRC16 initial value (0xffff) */
#define CRC16_INIT ((uint16_t)-1)

/**
 * calculate incremental CRC16 for given input byte
 *
 * @param[in] b new input byte/octet
 * @param[in] crc current CRC16
 * @return updated CRC16
 */
uint16_t crc16Incr(uint8_t b, uint16_t crc);

/**
 * check CRC16 checksum at the end of an sbuf chain
 *
 * @param[in] pHead pointer to head of sbuf chain
 * @param[in] len total data length over sbuf chain
 * @return true, if CRC16 match, false otherwise
 */
bool crc16Check(struct sbuf *pHead, size_t totLen);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* CRC_16_H */
