#!/bin/bash

TARGET="/run/media/mmcblk0p1"
XILINX=$(cat /proc/cpuinfo | grep "Hardware" | grep "Xilinx" | wc -l)
MMCBLK=$(lsblk -l | grep "$TARGET" | wc -l)

if [ "$1" == "-f" ]; then
    CONT="y"
fi

if [ "$HOSTNAME" == "CDI2_DeviceApp" ] && [ "$XILINX" == "1" ] && [ "$MMCBLK" == "1" ]; then

    if [ "$1" != "-f" ]; then
        read -p "Would your realy like to update BOOT.BIN, image.ub, boot.scr of this system (y/n)?" CONT
    fi
    
    if [ "$CONT" == "y" ]; then
        echo "INFO: updating BOOT.BIN, image.ub, boot.scr."
        rsync -v --info=progress2 BOOT.BIN image.ub boot.scr $TARGET
    fi
    
    if [ "$1" != "-f" ]; then
        read -p "Would your realy like to unpack rootfs.tar.gz to this system (y/n)?" CONT
    fi
    
    if [ "$CONT" == "y" ]; then
        echo "INFO: extracting rootfs.tar.gz"
        tar -xf "rootfs.tar.gz" -C / --checkpoint=.600
    fi
else
    echo "ERR: Simplified CDI2 Device not detected, exiting."
fi
