#!/bin/bash

IMG="."
APP="../../App"

#umount /dev/sdb1
#umount /dev/sdb2

set -e

mount /dev/sdb1 /media/sdb1
echo mount sdb1 ok

mount /dev/sdb2 /media/sdb2
echo mount sdb2 ok


rm -rf /media/sdb1/*
rm -rf /media/sdb2/*
echo cleaned disks ok

cp $IMG/BOOT.BIN /media/sdb1
cp $IMG/boot.scr /media/sdb1
cp $IMG/image.ub /media/sdb1
echo updated sdb1 ok

tar -xf $IMG/rootfs.tar.gz -C /media/sdb2

cp $APP/50cdi2 /media/sdb2/etc/ppp/ip-up.d/
chmod a+x /media/sdb2/etc/ppp/ip-up.d/50cdi2

cat $APP/interfaces > /media/sdb2/etc/network/interfaces

cp -r $APP /media/sdb2/home/petalinux
chown -R 1000:1000 /media/sdb2/home/petalinux
chmod a+x /media/sdb2/home/petalinux/App/*.sh
echo updated sdb2 ok

umount /dev/sdb1

umount /dev/sdb2
