#!/bin/python

import serial
import time
import struct
import re
import os
import sys
import threading
import select

active=True
delay=0.01    # send delay
duration=5*60   # run for 5 minutes then exit the threads gracefully

port = '/dev/ttyAMA0'
speed = 1250000
bytesize=serial.EIGHTBITS
parity=serial.PARITY_NONE
stopbits=serial.STOPBITS_ONE
read_timeout=None
select_timeout=0.0005
xonxoff=False
rtscts=False
write_timeout=None

# the shared serial port
ser = None

# staticstics variables
mi=99999999
ma=0
a=0
N=0
M=0

OSET=1683201300000000000

def writer():
  global M
  time.sleep(1) # let writer sleep one second to not write too early
  while active:
    time.sleep(delay)
    txt = '{}\n'.format(time.time_ns()-OSET)
    arr = bytes(txt, 'utf-8')
    ser.write(arr)
    M = M + 1
  # write one last sentence to interrupt a blocking read thread
  ser.write(bytes('exit\n', 'utf-8'))



def reader():
  global a, N, mi, ma, port, speed, nslow
  line=''
  while active:
    # wait until read is possible
    select.select([ser.fileno()],[],[],select_timeout)
    data = ser.readline().decode('utf-8')
    line=line+data
    l=len(line)
    if active and l>0 and line[l-1]=='\n':
      toc = time.time_ns()-OSET
      tic = int(line)
      diff = toc-tic
      a = a + diff
      N = N + 1
      mi = min(mi, diff)
      ma = max(ma, diff)
      if diff > 2000000: # if larger than 2ms
        print('{:.2f}'.format(diff/1000000.0))
#      print('{} x  {}'.format(line.replace('\n',''), toc))
      line=''

if __name__ == '__main__':
  if len(sys.argv) > 1:
    port = sys.argv[1]

  if len(sys.argv) > 2:
    read_timeout = float(sys.argv[2])

  if len(sys.argv) > 3:
    select_timeout = float(sys.argv[3])

  print('Using Port: {} @ {}'.format(port, speed))
  print('  read_timeout: {}'.format(read_timeout))
  print('  select_timeout: {}'.format(select_timeout))

  ser = serial.Serial(port, speed, bytesize, parity, stopbits, read_timeout, xonxoff, rtscts, write_timeout)

  t_reader = threading.Thread(target = reader)
  t_writer = threading.Thread(target = writer)

  t_reader.start()
  t_writer.start()

  time.sleep(duration)
  active=False

  t_reader.join()
  t_writer.join()

  print('TX N: {}'.format(M))
  print('RX N: {}'.format(N))
  print('min: {:.2f} ms'.format(mi/1000000.0))
  print('max: {:.2f} ms'.format(ma/1000000.0))
  print('avg: {:.2f} ms'.format((a / N)/1000000.0))
  print('')