#!/bin/bash

VER="1.36.1"
FILE="busybox-$VER.tar.bz2"

echo "INFO: downloading"
wget "https://busybox.net/downloads/$FILE"

echo "INFO: extracting"
tar -xf "$FILE"

PATCH=$(cat << EOF
@@ -458,7 +458,7 @@
 		/* Exits on error */
 		remote_fd = xconnect_stream(G.port_addr);
 
-	port_pasv_cleanup();
+	//port_pasv_cleanup();
 
 	if (remote_fd < 0)
 		return remote_fd;

EOF
)

echo "INFO: patch & configure make"

cd "busybox-$VER"
echo -e "$PATCH" | patch -r- --forward "./networking/ftpd.c"

make allnoconfig
sed 's/.*CONFIG_SHOW_USAGE.*/CONFIG_SHOW_USAGE=y/'               -i .config
sed 's/.*_VERBOSE_USAGE.*/CONFIG_FEATURE_VERBOSE_USAGE=y/'       -i .config
sed 's/.*CONFIG_FTPD.*/CONFIG_FTPD=y/'                           -i .config
sed 's/.*FTPD_WRITE.*/CONFIG_FEATURE_FTPD_WRITE=y/'              -i .config
sed 's/.*FTPD_ACCEP.*/CONFIG_FEATURE_FTPD_ACCEPT_BROKEN_LIST=y/' -i .config
sed 's/.*FTPD_AUTHE.*/CONFIG_FEATURE_FTPD_AUTHENTICATION=y/'     -i .config
sed 's/.*CONFIG_TCPSVD.*/CONFIG_TCPSVD=y/'                       -i .config
sed 's/.*CONFIG_FTPPUT.*/CONFIG_FTPPUT=y/'                       -i .config
sed 's/.*CONFIG_FTPGET.*/CONFIG_FTPGET=y/'                       -i .config

echo "INFO: compiling"
make LDFLAGS=-static

echo "INFO: testing"
RES=$(./busybox ftpd |& grep "$VER")
if [[ "$RES" == *"$VER"* ]]; then
  echo "INFO: busybox ftpd compilation success"
else
  echo "ERROR: busybox ftpd test failed"
  exit 1
fi

RES=$(./busybox tcpsvd |& grep "$VER")
if [[ "$RES" == *"$VER"* ]]; then
  echo "INFO: busybox tcpsvd compilation success"
else
  echo "ERROR: busybox tcpsvd test failed"
  exit 1
fi

read -t 5 -p "INFO: Would you like to install busybox to /usr/bin [Y/n]?" CONT
if [ "$CONT" = "y" ]; then
  cp ./busybox /usr/bin/
  ln /usr/bin/busybox /usr/bin/ftpd
  ln /usr/bin/busybox /usr/bin/tcpsvd
else
  echo -e "\nWARN: install skipped.\n"
fi
