#!/bin/bash
#-------------------------------------------------------------------------------
#
# cdi2-deamons.sh
#
# start pppd(8) and ftpd(8) deamons for the CDI2 Device applicaton
#
# (c)2023 AIT Austrian Institute of Technology
#-------------------------------------------------------------------------------

NODE_ID=1 # 1=camera, 2=detector
UART2="/dev/ttyS1"
SPEED="1152000"

while getopts "n:D:" arg; do
  case $arg in
    n)
      NODE_ID=$OPTARG
      ;;
    D)
      UART2=$OPTARG
      ;;
  esac
done

echo "INFO: Using UART2=$UART2, NODE_ID=$NODE_ID"

if [ "$(cat /proc/cpuinfo | grep Xilinx | wc -l)" == "0" ]; then
  # set correct speed of uart interface (not required on zync)
  SPEED=""
  echo "INFO: Configuring UART2 interface $UART2 on external computer."
  timeout 2 python ./cdi2DeviceApp.py -D $UART2 &> /dev/null
fi

if [ "$(echo $UART2 | grep USB | wc -l)" == "1" ]; then
  CFG="/sys/bus/usb-serial/devices/$(echo $UART2 | awk -F/ '{print $NF}')/latency_timer"
  echo "INFO: Setting latency_timer to 0 in file $CFG"
  echo 0 > "$CFG"
fi

echo "INFO: Preparing ip-up.d script"
cp ./50cdi2 /etc/ppp/ip-up.d/
chmod a+x /etc/ppp/ip-up.d/50cdi2

# start pppd(8) in background
pppd $UART2 $SPEED 192.168.100.$NODE_ID: file options.uart2 nodetach debug record ppp.log &
echo "INFO: Starting pppd in background (pid $!)"

# start last server, ftpd(8) in foreground
echo "INFO: Starting tcpsvd (ftpd) in foreground"
tcpsvd -vE 0.0.0.0 21 ftpd -w -A -vv ./ftp

