
--------------------------------------------------------------------------------
-- date Oct 30, 2017
--------------------------------------------------------------------------------
-- author Ylber Hasani
--------------------------------------------------------------------------------
-- copyright Copyright (c) 2017, Austrian Institute of Technology (AIT)
--------------------------------------------------------------------------------



library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
--use work.bsmttsPkg.all;

entity tts_top is
    port (

        clk_i                            : in  std_logic;
        rst_n_i                          : in  std_logic;
        --
        -- avmm_linetriggerpll_clk_i        : in  std_logic;
        -- avmm_linetriggerpll_addr_i       : in  std_logic_vector(6 downto 0);
        -- avmm_linetriggerpll_data_i       : in  std_logic_vector(31 downto 0);
        -- avmm_linetriggerpll_chipselect_i : in  std_logic;
        -- avmm_linetriggerpll_write_i      : in  std_logic;
        -- avmm_linetriggerpll_read_i       : in  std_logic;
        -- avmm_linetriggerpll_data_o       : out std_logic_vector(31 downto 0);
        --
        avmm_ttslogic_clk_i              : in  std_logic;
        avmm_ttslogic_addr_i             : in  std_logic_vector(6 downto 0);
        avmm_ttslogic_data_i             : in  std_logic_vector(31 downto 0);
        avmm_ttslogic_chipselect_i       : in  std_logic;
        avmm_ttslogic_write_i            : in  std_logic;
        avmm_ttslogic_read_i             : in  std_logic;
        avmm_ttslogic_data_o             : out std_logic_vector(31 downto 0);
        --
        irq_o                            : out std_logic;
        -- hpsdebugout_o                    : out std_logic_vector(31 downto 0);
        -- hpsdebugdir_o                    : out std_logic_vector(31 downto 0);
        -- hpsdebugin_i                     : in  std_logic_vector(31 downto 0);
        -- hpsdebugout_select_o             : out std_logic_vector(16 downto 0);
        -- led_out_o                        : out std_logic_vector(31 downto 0);
        -- speaker_period_o                 : out std_logic_vector(31 downto 0);
        -- speaker_ena_o                    : out std_logic_vector(31 downto 0);
        -- switch_i                         : in  std_logic_vector(3  downto 0);
        -- injecterror_tx_o                 : out std_logic;
        -- injecterror_rx_o                 : out std_logic;
        -- --
        -- global_sync_i                    : in  std_logic_vector(3 downto 0);
        -- global_sync_o                    : out std_logic_vector(3 downto 0);
        -- global_sync_d                    : out std_logic_vector(3 downto 0);
        -- fast_sync_i                      : in  std_logic_vector(2 downto 0);
        -- fast_sync_o                      : out std_logic_vector(2 downto 0);
        -- trigger_i                        : in  std_logic_vector(2 downto 0);
        --
        -- tcclk_i                          : in  std_logic;
        -- sync_i                           : in  std_logic;
        -- bntrig_i                         : in  std_logic;
        -- timerpulse_i                     : in  std_logic;
        --
        tts_tc_i                         : in  std_logic;
        tts_bp_i                         : in  std_logic;
        tts_reset_i                      : in  std_logic;
        tts_ready_o                      : out std_logic);
        --
        -- tts_tc_o                         : out std_logic_vector(8 downto 0);
        -- tts_bp_o                         : out std_logic_vector(8 downto 0);
        -- tts_ready_i                      : in  std_logic_vector(8 downto 0);
        -- tts_reset_o                      : out std_logic_vector(8 downto 0));
end entity tts_top;


architecture rtl of tts_top is

signal s_clk20 : std_logic;

begin


-- LINETRIGGER_PLL: entity work.linetrigger_pll
    -- port map(
        -- clk_i                => clk_i,
        -- reset_n_i            => rst_n_i,
        -- --
        -- linetrigger_i        => tcclk_i,
        -- linetrigger_o        => s_clk20,
        -- --
        -- avmm_clk_i           => avmm_linetriggerpll_clk_i,
        -- avmm_addr_i          => avmm_linetriggerpll_addr_i,
        -- avmm_data_i          => avmm_linetriggerpll_data_i,
        -- avmm_chipselect_i    => avmm_linetriggerpll_chipselect_i,
        -- avmm_write_i         => avmm_linetriggerpll_write_i,
        -- avmm_read_i          => avmm_linetriggerpll_read_i,
        -- avmm_data_o          => avmm_linetriggerpll_data_o);


TTS_LOGIC: entity work.tts_logic
    port map(
        clk_i                => clk_i,
        rst_n_i              => rst_n_i,
        --
        avmm_clk_i           => avmm_ttslogic_clk_i,
        avmm_addr_i          => avmm_ttslogic_addr_i,
        avmm_data_i          => avmm_ttslogic_data_i,
        avmm_chipselect_i    => avmm_ttslogic_chipselect_i,
        avmm_write_i         => avmm_ttslogic_write_i,
        avmm_read_i          => avmm_ttslogic_read_i,
        avmm_data_o          => avmm_ttslogic_data_o,
        -- --
        -- clk_20_i             => s_clk20,
        -- sync_i               => sync_i,
        -- bntrig_i             => bntrig_i,
        -- timerpulse_i         => timerpulse_i,
        --
        tts_tc_i             => tts_tc_i,
        tts_bp_i             => tts_bp_i,
        tts_reset_i          => tts_reset_i,
        tts_ready_o          => tts_ready_o,
        --
        irq_o                => irq_o);
        -- hpsdebugout_o        => hpsdebugout_o,
        -- hpsdebugdir_o        => hpsdebugdir_o,
        -- hpsdebugin_i         => hpsdebugin_i,
        -- hpsdebugout_select_o => hpsdebugout_select_o,
        -- led_out_o            => led_out_o,
        -- speaker_period_o     => speaker_period_o,
        -- speaker_ena_o        => speaker_ena_o,
        -- switch_i             => switch_i,
        -- injecterror_tx_o     => injecterror_tx_o,
        -- injecterror_rx_o     => injecterror_rx_o,
        -- --
        -- global_sync_i        => global_sync_i,
        -- global_sync_o        => global_sync_o,
        -- global_sync_d        => global_sync_d,
        -- fast_sync_i          => fast_sync_i,
        -- fast_sync_o          => fast_sync_o,
          -- trigger_i            => trigger_i,
        -- --
        -- tts_tc_o             => tts_tc_o,
        -- tts_bp_o             => tts_bp_o,
        -- tts_ready_i          => tts_ready_i,
        -- tts_reset_o          => tts_reset_o);

end rtl;
