
--------------------------------------------------------------------------------
-- date Oct 30, 2017
--------------------------------------------------------------------------------
-- author Ylber Hasani
--------------------------------------------------------------------------------
-- copyright Copyright (c) 2017, Austrian Institute of Technology (AIT)
--------------------------------------------------------------------------------



library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
--use work.bsmttsPkg.all;

entity tts_logic is
    port (

        clk_i                : in  std_logic;
        rst_n_i              : in  std_logic;
        --
        avmm_clk_i           : in  std_logic;
        avmm_addr_i          : in  std_logic_vector(6 downto 0);
        avmm_data_i          : in  std_logic_vector(31 downto 0);
        avmm_chipselect_i    : in  std_logic;
        avmm_write_i         : in  std_logic;
        avmm_read_i          : in  std_logic;
        avmm_data_o          : out std_logic_vector(31 downto 0);
        -- --
        -- clk_20_i             : in  std_logic;
        -- sync_i               : in  std_logic;
        -- bntrig_i             : in  std_logic;
        -- timerpulse_i         : in  std_logic;
        --
        tts_tc_i             : in  std_logic;
        tts_bp_i             : in  std_logic;
        tts_reset_i          : in  std_logic;
        tts_ready_o          : out std_logic;
        --
        irq_o                : out std_logic);
        -- hpsdebugout_o        : out std_logic_vector(31 downto 0);
        -- hpsdebugdir_o        : out std_logic_vector(31 downto 0);
        -- hpsdebugin_i         : in  std_logic_vector(31 downto 0);
        -- hpsdebugout_select_o : out std_logic_vector(16 downto 0);
        -- led_out_o            : out std_logic_vector(31 downto 0);
        -- speaker_period_o     : out std_logic_vector(31 downto 0);
        -- speaker_ena_o        : out std_logic_vector(31 downto 0);
        -- switch_i             : in  std_logic_vector(3  downto 0);
        -- injecterror_tx_o     : out std_logic;
        -- injecterror_rx_o     : out std_logic;
        -- --
        -- global_sync_i        : in  std_logic_vector(3 downto 0);
        -- global_sync_o        : out std_logic_vector(3 downto 0);
        -- global_sync_d        : out std_logic_vector(3 downto 0);
        -- fast_sync_i          : in  std_logic_vector(2 downto 0);
        -- fast_sync_o          : out std_logic_vector(2 downto 0);
        -- trigger_i            : in  std_logic_vector(2 downto 0);
        -- --
        -- tts_tc_o             : out std_logic_vector(8 downto 0);
        -- tts_bp_o             : out std_logic_vector(8 downto 0);
        -- tts_ready_i          : in  std_logic_vector(8 downto 0);
        -- tts_reset_o          : out std_logic_vector(8 downto 0));

end entity tts_logic;

architecture rtl of tts_logic is

-- signal s_tccnt_sync               : std_logic_vector(31 downto 0);
-- signal s_tccnt_load               : std_logic_vector(31 downto 0);
-- signal s_inttrig_notexttrig       : std_logic_vector(31 downto 0);
-- signal s_inttrig_start            : std_logic_vector(31 downto 0);
-- signal s_inttrig_start_edge       : std_logic;
-- signal s_inttrig_number           : std_logic_vector(31 downto 0);
-- signal s_inttrig_distance         : std_logic_vector(31 downto 0);
-- signal s_inttrig_busy             : std_logic_vector(31 downto 0);
-- signal s_tcperiod                 : std_logic_vector(31 downto 0);
-- signal s_new_tcperiod             : std_logic;
-- signal s_tccnt_value              : std_logic_vector(31 downto 0);
-- signal s_bntrigirq                : std_logic_vector(31 downto 0);
signal s_irq_enable               : std_logic_vector(31 downto 0);
signal s_irq_clear                : std_logic_vector(31 downto 0);
signal s_irq_clear_edge           : std_logic;
signal s_clear_irq_pending        : std_logic_vector(31 downto 0);
signal s_irq_pending              : std_logic_vector(31 downto 0);
signal s_irq_set                  : std_logic_vector(31 downto 0);
signal s_irq_set_edge             : std_logic;
signal s_set_irq_pending          : std_logic_vector(31 downto 0);
-- signal s_bntrigger_r              : std_logic;
-- signal s_bntrigger_edge           : std_logic;
-- signal s_tccnt_value_bntrig       : std_logic_vector(31 downto 0);
-- signal s_tccnt_value_timerpulse   : std_logic_vector(31 downto 0);
-- signal s_new_bptrigupdate_edge    : std_logic_vector(8 downto 0);
-- signal s_sync_clear_fifo          : std_logic_vector(31 downto 0);
-- signal s_sync_clear_fifo_edge     : std_logic;

-- signal s_tts_config               : configregArray(8 downto 0);
-- signal s_bptrigupdate             : configregArray(8 downto 0);
-- signal s_bppulsewidth             : configregArray(8 downto 0);
-- signal s_reset_out                : configregArray(8 downto 0);
-- signal s_ready_in                 : configregArray(8 downto 0);

-- signal s_clk_01                   : std_logic;
-- signal s_clk_02                   : std_logic;
-- signal s_clk_05                   : std_logic;
-- signal s_clk_10                   : std_logic;
-- signal s_bntrigger                : std_logic;
-- signal s_tccnt                    : std_logic_vector(31 downto 0);

signal s_tts_bp_redge             : std_logic;
signal s_ttsready_device          : std_logic;
signal s_ttstc_period             : std_logic_vector(31 downto 0);
signal s_new_ttstc_period         : std_logic;
signal s_ttsbp_period             : std_logic_vector(31 downto 0);
signal s_new_ttsbp_period         : std_logic;
signal s_ttsbp_duration           : std_logic_vector(31 downto 0);
signal s_new_ttsbp_duration       : std_logic;
signal s_ttsbp_numbers            : std_logic_vector(31 downto 0);
signal s_new_ttsbp_numbers        : std_logic;
signal s_clear_ttsbp_numbers      : std_logic;
signal s_ttsifc_status            : std_logic_vector(31 downto 0);

signal s_tts_tc                   : std_logic;
signal s_tts_bp                   : std_logic;
signal s_tts_reset                : std_logic;

-- signal s_tts_tc_o                 : std_logic_vector(8 downto 0);
-- signal s_tts_bp_o                 : std_logic_vector(8 downto 0);
-- signal s_tts_reset_o              : std_logic_vector(8 downto 0);
-- signal s_tts_ready_i              : std_logic_vector(8 downto 0);

-- signal s_mux_tts_tc_o             : std_logic;
-- signal s_mux_tts_bp_o             : std_logic;
-- signal s_mux_tts_reset_o          : std_logic;

-- signal s_testmode                 : std_logic_vector(31 downto 0);

-- signal s_tx_injecterror_numbers   : std_logic_vector(31 downto 0);
-- signal s_tx_injecterror_distance  : std_logic_vector(31 downto 0);
-- signal s_tx_injecterror_edge      : std_logic;
-- signal s_rx_injecterror_numbers   : std_logic_vector(31 downto 0);
-- signal s_rx_injecterror_distance  : std_logic_vector(31 downto 0);
-- signal s_rx_injecterror_edge      : std_logic;

-- signal s_timerpulse_sync          : std_logic_vector(2  downto 0);
-- signal s_injecterror_tx           : std_logic;
-- signal s_cnt_after_timerpulse_tx  : unsigned(31 downto 0);
-- signal s_cnt_injecterror_tx       : unsigned(31 downto 0);
-- signal s_active_injecterror_tx    : std_logic;
-- signal s_injecterror_rx           : std_logic;
-- signal s_cnt_after_timerpulse_rx  : unsigned(31 downto 0);
-- signal s_cnt_injecterror_rx       : unsigned(31 downto 0);
-- signal s_active_injecterror_rx    : std_logic;

-- signal s_fast_sync                : std_logic_vector(2  downto 0);
-- signal s_fast_sync_select         : std_logic_vector(1  downto 0);
-- signal s_nonTTS_bp                : std_logic;
-- signal s_nonTTS_tc                : std_logic;

-- signal s_soc_tcnt                 : std_logic_vector(31 downto 0);
-- signal s_soc_tcnt_edge            : std_logic;
-- signal s_bptime_aftersoc          : std_logic_vector(31 downto 0);
-- signal s_new_bptime_aftersoc      : std_logic;
-- signal s_cnt_time_aftersoc        : unsigned(31 downto 0);


begin


  -- MASTER_TIMING : entity work.master_timing
  -- port map(

      -- clk_i                => clk_i,
      -- rst_n_i              => rst_n_i,

      -- clk_20_i             => clk_20_i,
      -- sync_i               => sync_i,
      -- timerpulse_i         => timerpulse_i,
      -- bntrig_i             => bntrig_i,

      -- tccnt_sync_i         => s_tccnt_sync,
      -- tccnt_load_i         => s_tccnt_load,
      -- inttrig_notexttrig_i => s_inttrig_notexttrig,
      -- inttrig_start_i      => s_inttrig_start,
      -- inttrig_start_edge_i => s_inttrig_start_edge,
      -- inttrig_number_i     => s_inttrig_number,
      -- inttrig_distance_i   => s_inttrig_distance,
      -- inttrig_busy_o       => s_inttrig_busy,
      -- tcperiod_o           => s_tcperiod,
      -- new_tcperiod_o       => s_new_tcperiod,
      -- tccnt_value_o        => s_tccnt_value,
      -- tccnt_value_bntrig_o => s_tccnt_value_bntrig,
      -- tccnt_value_timerpulse_o => s_tccnt_value_timerpulse,

      -- clk_01_o             => s_clk_01,
      -- clk_02_o             => s_clk_02,
      -- clk_05_o             => s_clk_05,
      -- clk_10_o             => s_clk_10,
      -- trigger_o            => s_bntrigger,
      -- tccnt_o              => s_tccnt);

  -- GEN_TTS_GEN: for i in 0 to 8 generate
  -- TTS_GEN: entity work.tts_gen
  -- port map (
      -- clk_i                => clk_i,
      -- rst_n_i              => rst_n_i,

      -- clk_01_i             => s_clk_01,
      -- clk_02_i             => s_clk_02,
      -- clk_05_i             => s_clk_05,
      -- clk_10_i             => s_clk_10,

      -- trigger_i            => s_bntrigger,
      -- tccnt_i              => s_tccnt,

      -- tts_config_i         => s_tts_config(i),
      -- bptrig_update_i         => s_bptrigupdate(i),
      -- new_bptrigupdate_edge_i => s_new_bptrigupdate_edge(i),
      -- sync_clear_fifo_i       => s_sync_clear_fifo(i),
      -- sync_clear_fifo_edge_i  => s_sync_clear_fifo_edge,
      -- bppulsewidth_i       => s_bppulsewidth(i),
      -- reset_out_i          => s_reset_out(i),
      -- ready_in_o           => s_ready_in(i),

      -- --tts_tc_o             => tts_tc_o(i),
      -- --tts_bp_o             => tts_bp_o(i),
      -- --tts_ready_i          => tts_ready_i(i),
      -- --tts_reset_o          => tts_reset_o(i));

      -- tts_tc_o             => s_tts_tc_o(i),
      -- tts_bp_o             => s_tts_bp_o(i),
      -- tts_ready_i          => s_tts_ready_i(i),
      -- tts_reset_o          => s_tts_reset_o(i));

  -- end generate GEN_TTS_GEN;


  -- -- mux input or tts output[s_testmode(3 downto 0) = "0001"] for device tts input
  -- -- enable tts output[s_testmode(8) = '1']
  -- p_mux_input_or_loopback: process (clk_i,rst_n_i) is
  -- begin
    -- if (rst_n_i = '0') then
        -- s_tts_tc          <= '0';
        -- s_tts_bp          <= '0';
        -- s_tts_reset       <= '0';

        -- s_mux_tts_tc_o    <= '0';
        -- s_mux_tts_bp_o    <= '0';
        -- s_mux_tts_reset_o <= '0';

        -- tts_tc_o          <= (others => '0');
        -- tts_bp_o          <= (others => '0');
        -- tts_reset_o       <= (others => '0');
        -- s_tts_ready_i     <= (others => '0');



    -- elsif (rising_edge(clk_i)) then
        -- -- mux channel to device tts input for testmode
        -- if   (s_testmode(7 downto 4) = "0000") then
            -- s_mux_tts_tc_o    <= s_tts_tc_o(0);
            -- s_mux_tts_bp_o    <= s_tts_bp_o(0);
            -- s_mux_tts_reset_o <= s_tts_reset_o(0);
        -- elsif (s_testmode(7 downto 4) = "0001") then
            -- s_mux_tts_tc_o    <= s_tts_tc_o(1);
            -- s_mux_tts_bp_o    <= s_tts_bp_o(1);
            -- s_mux_tts_reset_o <= s_tts_reset_o(1);
        -- elsif (s_testmode(7 downto 4) = "0010") then
            -- s_mux_tts_tc_o    <= s_tts_tc_o(2);
            -- s_mux_tts_bp_o    <= s_tts_bp_o(2);
            -- s_mux_tts_reset_o <= s_tts_reset_o(2);
        -- elsif (s_testmode(7 downto 4) = "0011") then
            -- s_mux_tts_tc_o    <= s_tts_tc_o(3);
            -- s_mux_tts_bp_o    <= s_tts_bp_o(3);
            -- s_mux_tts_reset_o <= s_tts_reset_o(3);
        -- elsif (s_testmode(7 downto 4) = "0100") then
            -- s_mux_tts_tc_o    <= s_tts_tc_o(4);
            -- s_mux_tts_bp_o    <= s_tts_bp_o(4);
            -- s_mux_tts_reset_o <= s_tts_reset_o(4);
        -- elsif (s_testmode(7 downto 4) = "0101") then
            -- s_mux_tts_tc_o    <= s_tts_tc_o(5);
            -- s_mux_tts_bp_o    <= s_tts_bp_o(5);
            -- s_mux_tts_reset_o <= s_tts_reset_o(5);
        -- elsif (s_testmode(7 downto 4) = "0110") then
            -- s_mux_tts_tc_o    <= s_tts_tc_o(6);
            -- s_mux_tts_bp_o    <= s_tts_bp_o(6);
            -- s_mux_tts_reset_o <= s_tts_reset_o(6);
        -- elsif (s_testmode(7 downto 4) = "0111") then
            -- s_mux_tts_tc_o    <= s_tts_tc_o(7);
            -- s_mux_tts_bp_o    <= s_tts_bp_o(7);
            -- s_mux_tts_reset_o <= s_tts_reset_o(7);
        -- elsif (s_testmode(7 downto 4) = "1000") then
            -- s_mux_tts_tc_o    <= s_tts_tc_o(8);
            -- s_mux_tts_bp_o    <= s_tts_bp_o(8);
            -- s_mux_tts_reset_o <= s_tts_reset_o(8);
        -- else
            -- s_mux_tts_tc_o    <= '0';
            -- s_mux_tts_bp_o    <= '0';
            -- s_mux_tts_reset_o <= '0';
        -- end if;
        -- -- device ifc tts input
        -- if   (s_testmode(3 downto 0) = "0000") then
            -- s_tts_tc    <= tts_tc_i;
            -- s_tts_bp    <= tts_bp_i;
            -- s_tts_reset <= tts_reset_i;
        -- elsif(s_testmode(3 downto 0) = "0001") then
            -- s_tts_tc    <= s_mux_tts_tc_o;
            -- s_tts_bp    <= s_mux_tts_bp_o;
            -- s_tts_reset <= s_mux_tts_reset_o;
        -- end if;


        -- -- default
        -- tts_tc_o      <= s_tts_tc_o;
        -- tts_bp_o      <= s_tts_bp_o;
        -- tts_reset_o   <= s_tts_reset_o;
        -- s_tts_ready_i <= tts_ready_i;

        -- -- tts out in loopbackmodus
        -- if (s_testmode(3 downto 0) = "0001") then
            -- if (s_testmode(8) = '0') then
                -- tts_tc_o      <= (others => '0');
                -- tts_bp_o      <= (others => '0');
                -- tts_reset_o   <= (others => '0');
                -- s_tts_ready_i <= (others => '0');
            -- end if;
        -- end if;


    -- end if;
  -- end process p_mux_input_or_loopback;





  -- injecterror_tx_o <= s_injecterror_tx;
  -- injecterror_rx_o <= s_injecterror_rx;
  -- --
  -- p_injectCRC_error: process (clk_i,rst_n_i) is
  -- begin
    -- if (rst_n_i = '0') then

        -- s_timerpulse_sync <= (others => '0');

        -- s_injecterror_tx <= '0';
        -- s_cnt_after_timerpulse_tx <= (others => '0');
        -- s_cnt_injecterror_tx <= (others => '0');
        -- s_active_injecterror_tx <= '0';

        -- s_injecterror_rx <= '0';
        -- s_cnt_after_timerpulse_rx <= (others => '0');
        -- s_cnt_injecterror_rx <= (others => '0');
        -- s_active_injecterror_rx <= '0';

    -- elsif (rising_edge(clk_i)) then

        -- -- sync timerpulse_i
        -- s_timerpulse_sync(0) <= timerpulse_i;
        -- s_timerpulse_sync(2 downto 1) <= s_timerpulse_sync(1 downto 0);

        -- -- TX error inject
        -- s_injecterror_tx <= '0';

        -- if (s_active_injecterror_tx = '1') then
            -- if (s_timerpulse_sync(1) = '1' and s_timerpulse_sync(2) = '0') then
              -- s_cnt_after_timerpulse_tx <= conv_unsigned(1,s_cnt_after_timerpulse_tx'length);
            -- elsif (s_cnt_after_timerpulse_tx > conv_unsigned(0, s_cnt_after_timerpulse_tx'length)) then
                -- s_cnt_after_timerpulse_tx <= s_cnt_after_timerpulse_tx + conv_unsigned(1,1);
            -- end if;

            -- if (s_cnt_after_timerpulse_tx = unsigned(s_tx_injecterror_distance)) then
                -- s_injecterror_tx <= '1';
                -- s_cnt_after_timerpulse_tx <= conv_unsigned(0, s_cnt_after_timerpulse_tx'length);
            -- end if;

            -- if (s_injecterror_tx = '1') then
                -- s_cnt_injecterror_tx <= s_cnt_injecterror_tx + conv_unsigned(1,1);
            -- end if;
        -- end if;


        -- if  (s_cnt_injecterror_tx = unsigned(s_tx_injecterror_numbers) or s_tx_injecterror_numbers = X"00000000")then
            -- s_cnt_after_timerpulse_tx <= (others => '0');
            -- s_cnt_injecterror_tx      <= (others => '0');
            -- s_injecterror_tx          <= '0';
            -- s_active_injecterror_tx   <= '0';
        -- end if;

        -- if (s_tx_injecterror_edge = '1' and s_tx_injecterror_numbers /= X"00000000") then
            -- s_cnt_after_timerpulse_tx <= (others => '0');
            -- s_cnt_injecterror_tx      <= (others => '0');
            -- s_injecterror_tx          <= '0';
            -- s_active_injecterror_tx   <= '1';
        -- end if;

        -- if (s_tx_injecterror_numbers = X"FFFFFFFF") then
          -- --s_cnt_after_timerpulse_tx <= (others => '0');
            -- s_cnt_injecterror_tx      <= (others => '0');
          -- --s_injecterror_tx          <= '0';
            -- s_active_injecterror_tx   <= '1';
        -- end if;


        -- -- rx error inject
        -- s_injecterror_rx <= '0';

        -- if (s_active_injecterror_rx = '1') then
            -- if (s_timerpulse_sync(1) = '1' and s_timerpulse_sync(2) = '0') then
              -- s_cnt_after_timerpulse_rx <= conv_unsigned(1,s_cnt_after_timerpulse_rx'length);
            -- elsif (s_cnt_after_timerpulse_rx > conv_unsigned(0, s_cnt_after_timerpulse_rx'length)) then
                -- s_cnt_after_timerpulse_rx <= s_cnt_after_timerpulse_rx + conv_unsigned(1,1);
            -- end if;

            -- if (s_cnt_after_timerpulse_rx = unsigned(s_rx_injecterror_distance)) then
                -- s_injecterror_rx <= '1';
                -- s_cnt_after_timerpulse_rx <= conv_unsigned(0, s_cnt_after_timerpulse_rx'length);
            -- end if;

            -- if (s_injecterror_rx = '1') then
                -- s_cnt_injecterror_rx <= s_cnt_injecterror_rx + conv_unsigned(1,1);
            -- end if;
        -- end if;


        -- if  (s_cnt_injecterror_rx = unsigned(s_rx_injecterror_numbers) or s_rx_injecterror_numbers = X"00000000") then
            -- s_cnt_after_timerpulse_rx <= (others => '0');
            -- s_cnt_injecterror_rx      <= (others => '0');
            -- s_injecterror_rx          <= '0';
            -- s_active_injecterror_rx   <= '0';
        -- end if;

        -- if (s_rx_injecterror_edge = '1' and s_rx_injecterror_numbers /= X"00000000") then
            -- s_cnt_after_timerpulse_rx <= (others => '0');
            -- s_cnt_injecterror_rx      <= (others => '0');
            -- s_injecterror_rx          <= '0';
            -- s_active_injecterror_rx   <= '1';
        -- end if;

        -- if (s_rx_injecterror_numbers = X"FFFFFFFF") then
          -- --s_cnt_after_timerpulse_rx <= (others => '0');
            -- s_cnt_injecterror_rx      <= (others => '0');
          -- --s_injecterror_rx          <= '0';
            -- s_active_injecterror_rx   <= '1';
        -- end if;

    -- end if;
  -- end process p_injectCRC_error;


  TTS_DEVICEIFC: entity work.tts_deviceifc
  port map (

      clk_i                => clk_i,
      rst_n_i              => rst_n_i,

      tts_tc_i             => tts_tc_i,
      tts_bp_i             => tts_bp_i,
      tts_reset_i          => tts_reset_i,
    --tts_tc_i             => s_tts_tc,
    --tts_bp_i             => s_tts_bp,
    --tts_reset_i          => s_tts_reset,
      tts_ready_o          => tts_ready_o,

      tts_bp_redge_o       => s_tts_bp_redge,
      ttsready_device_i    => s_ttsready_device,
      ttstc_period_o       => s_ttstc_period,
      new_ttstc_period_o   => s_new_ttstc_period,
      ttsbp_period_o       => s_ttsbp_period,
      new_ttsbp_period_o   => s_new_ttsbp_period,
      ttsbp_duration_o     => s_ttsbp_duration,
      new_ttsbp_duration_o => s_new_ttsbp_duration,
      ttsbp_numbers_o      => s_ttsbp_numbers,
      new_ttsbp_numbers_o  => s_new_ttsbp_numbers,
      clear_ttsbp_numbers_i=> s_clear_ttsbp_numbers,
      ttsifc_status_o      => s_ttsifc_status
      );

  CONFIG_TTSLOGIC : entity work.config_ttslogic
  port map(
      clk_i                     => clk_i,
      rst_n_i                   => rst_n_i,
      --
      avmm_clk_i                => avmm_clk_i,
      avmm_addr_i               => avmm_addr_i,
      avmm_data_i               => avmm_data_i,
      avmm_chipselect_i         => avmm_chipselect_i,
      avmm_write_i              => avmm_write_i,
      avmm_read_i               => avmm_read_i,
      avmm_data_o               => avmm_data_o,
      -- -- master timing parameter
      -- tccnt_sync_o              => open, --s_tccnt_sync,
      -- tccnt_load_o              => open, --s_tccnt_load,
      -- inttrig_notexttrig_o      => open, --s_inttrig_notexttrig,
      -- inttrig_start_o           => open, --s_inttrig_start,
      -- inttrig_start_edge_o      => open, --s_inttrig_start_edge,
      -- inttrig_number_o          => open, --s_inttrig_number,
      -- inttrig_distance_o        => open, --s_inttrig_distance,
      -- inttrig_busy_i            => (others => '0'),--s_inttrig_busy,
      -- tcperiod_i                => (others => '0'),--s_tcperiod,
      -- new_tcperiod_i            => '0',--s_new_tcperiod,
      -- tccnt_value_i             => (others => '0'),--s_tccnt_value,
      -- tccnt_value_bntrig_i      => (others => '0'),--s_tccnt_value_bntrig,
      -- tccnt_value_timerpulse_i  => (others => '0'),--s_tccnt_value_timerpulse,
      -- -- tts_gen parameter
      -- tts_config_o              => s_tts_config,
      -- bptrigupdate_o            => s_bptrigupdate,
      -- bppulsewidth_o            => s_bppulsewidth,
      -- new_bptrigupdate_edge_o   => open, --s_new_bptrigupdate_edge,
      -- sync_clear_fifo_o         => open, --s_sync_clear_fifo,
      -- sync_clear_fifo_edge_o    => open, --s_sync_clear_fifo_edge,
      -- reset_out_o               => s_reset_out,
      -- ready_in_i                => s_ready_in,
      -- tts device ifc parameter
      ttsready_device_o         => s_ttsready_device,
      ttstc_period_i            => s_ttstc_period,
      new_ttstc_period_i        => s_new_ttstc_period,
      ttsbp_period_i            => s_ttsbp_period,
      new_ttsbp_period_i        => s_new_ttsbp_period,
      ttsbp_duration_i          => s_ttsbp_duration,
      new_ttsbp_duration_i      => s_new_ttsbp_duration,
      ttsbp_numbers_i           => s_ttsbp_numbers,
      new_ttsbp_numbers_i       => s_new_ttsbp_numbers,
      clear_ttsbp_numbers_o     => s_clear_ttsbp_numbers,
      ttsifc_status_i           => s_ttsifc_status,
      -- testmode_o                => open, --s_testmode,
      -- irq gen parameter
      irq_enable_o              => s_irq_enable,
      irq_clear_o               => s_irq_clear,
      irq_clear_edge_o          => s_irq_clear_edge,
      irq_set_o                 => s_irq_set,
      irq_set_edge_o            => s_irq_set_edge,
      irq_pending_i             => s_irq_pending);
      -- --
      -- global_sync_i             => (others => '0'),--global_sync_i,
      -- global_sync_o             => open, --global_sync_o,
      -- global_sync_d             => open, --global_sync_d,
      -- fast_sync_i               => (others => '0'),--fast_sync_i,
      -- fast_sync_o               => open, --s_fast_sync,
      -- fast_sync_select_o        => open, --s_fast_sync_select,
      -- trigger_i                 => (others => '0'),--trigger_i,
      -- --
      -- hpsdebugout_o             => open,   --hpsdebugout_o,
      -- hpsdebugdir_o             => open,   --hpsdebugdir_o,
      -- hpsdebugin_i              => open,   --hpsdebugin_i,
      -- hpsdebugout_select_o      => open,   --hpsdebugout_select_o,
      -- led_out_o                 => open,   --led_out_o,
      -- speaker_period_o          => open,   --speaker_period_o,
      -- speaker_ena_o             => open,   --speaker_ena_o,
      -- switch_i                  => (others => '0'),--switch_i,
      -- tx_injecterror_numbers_o  => open,   --s_tx_injecterror_numbers,
      -- tx_injecterror_distance_o => open,   --s_tx_injecterror_distance,
      -- tx_injecterror_edge_o     => open,   --s_tx_injecterror_edge,
      -- rx_injecterror_numbers_o  => open,   --s_rx_injecterror_numbers,
      -- rx_injecterror_distance_o => open,   --s_rx_injecterror_distance,
      -- rx_injecterror_edge_o     => open,   --s_rx_injecterror_edge,
      -- soc_tcnt_o                => open,   --s_soc_tcnt,
      -- soc_tcnt_edge_o           => open,   --s_soc_tcnt_edge,
      -- bptime_aftersoc_i         => (others => '0'),--s_bptime_aftersoc,
      -- new_bptime_aftersoc_i     => '0');--s_new_bptime_aftersoc);

  -- p_cnt_after_soc_until_bp: process (clk_i,rst_n_i) is
  -- begin
    -- if (rst_n_i = '0') then

        -- s_cnt_time_aftersoc <= (others => '0');
        -- s_bptime_aftersoc <= (others => '0');
        -- s_new_bptime_aftersoc <= '0';

    -- elsif (rising_edge(clk_i)) then

        -- if (s_soc_tcnt_edge = '1') then
            -- s_cnt_time_aftersoc <= unsigned(s_soc_tcnt);
        -- elsif(s_cnt_time_aftersoc > conv_unsigned(0, s_cnt_time_aftersoc'length)) then
            -- s_cnt_time_aftersoc <= s_cnt_time_aftersoc + conv_unsigned(1,1);
        -- end if;

        -- s_new_bptime_aftersoc <= '0';
        -- if (s_tts_bp_redge = '1') then
            -- s_new_bptime_aftersoc <= '1';
            -- s_bptime_aftersoc <= std_logic_vector(s_cnt_time_aftersoc);
        -- end if;

    -- end if;
  -- end process p_cnt_after_soc_until_bp;

  -- p_fast_sync_out: process (clk_i,rst_n_i) is
  -- begin
    -- if (rst_n_i = '0') then

        -- fast_sync_o <= (others => '0');

    -- elsif (rising_edge(clk_i)) then

        -- --if not [00&01&10] selected then
        -- fast_sync_o <= (others => '0');

        -- -- Fast Sync output select
        -- if (s_fast_sync_select = "00") then
            -- fast_sync_o(0) <= s_fast_sync(0);
            -- fast_sync_o(1) <= s_fast_sync(1);
            -- fast_sync_o(2) <= s_fast_sync(2);
        -- elsif (s_fast_sync_select = "01") then
            -- fast_sync_o(0) <= tts_bp_i;
            -- fast_sync_o(1) <= tts_tc_i;
            -- fast_sync_o(2) <= '0';
        -- elsif (s_fast_sync_select = "10") then
            -- fast_sync_o(0) <= s_nonTTS_bp;
            -- fast_sync_o(1) <= s_nonTTS_tc;
            -- fast_sync_o(2) <= '0';
        -- end if;

    -- end if;
  -- end process p_fast_sync_out;



  p_bntrigirq_gen: process (clk_i,rst_n_i) is
  begin
    if (rst_n_i = '0') then

        s_irq_pending <= (others => '0');


        s_clear_irq_pending <= (others => '0');
        s_set_irq_pending <= (others => '0');

        -- s_bntrigger_r <= '0';
        -- s_bntrigger_edge <= '0';
        irq_o <= '0';

    elsif (rising_edge(clk_i)) then


        s_clear_irq_pending <= (others => '0');
        for i in 0 to 31 loop
            if (s_irq_clear(i) = '1' and s_irq_clear_edge = '1') then
                s_clear_irq_pending(i) <= '1';
            end if;
        end loop;


        s_set_irq_pending <= (others => '0');
        for i in 0 to 31 loop
            if (s_irq_set(i) = '1' and s_irq_set_edge = '1') then
                s_set_irq_pending(i) <= '1';
            end if;
        end loop;

        -- s_bntrigger_r <= s_bntrigger;
        -- s_bntrigger_edge <= '0';
        -- if (s_bntrigger = '1' and s_bntrigger_r = '0') then
            -- s_bntrigger_edge <= '1';
        -- end if;

        -- IRQ Bit 0 / BNTRIGGER
        if (s_irq_enable(0) = '0') then
            s_irq_pending(0) <= '0';
        elsif (s_clear_irq_pending(0) = '1') then
            s_irq_pending(0) <= '0';
        elsif (s_set_irq_pending(0) = '1') then
            s_irq_pending(0) <= '1';
        --elsif (s_bntrigger_edge = '1') then
        --    s_irq_pending(0) <= '1';
        end if;

        -- IRQ Bit 1 / BPTRIGGER
        if (s_irq_enable(1) = '0') then
            s_irq_pending(1) <= '0';
        elsif (s_clear_irq_pending(1) = '1') then
            s_irq_pending(1) <= '0';
        elsif (s_set_irq_pending(1) = '1') then
            s_irq_pending(1) <= '1';
        elsif (s_tts_bp_redge = '1') then
            s_irq_pending(1) <= '1';
        end if;

        -- IRQ Bit 31 to 2, Bits 31:16 reserved for nios generated IRQ's
        for i in 2 to 31 loop
            if (s_irq_enable(i) = '0') then
                s_irq_pending(i) <= '0';
            elsif (s_clear_irq_pending(i) = '1') then
                s_irq_pending(i) <= '0';
            elsif (s_set_irq_pending(i) = '1') then
                s_irq_pending(i) <= '1';
            end if;
        end loop;


        if (s_irq_pending /= X"00000000") then
            irq_o <= '1';
        else
            irq_o <= '0';
        end if;

    end if;
  end process p_bntrigirq_gen;

end rtl;
