

--------------------------------------------------------------------------------
-- date Oct 30, 2017
--------------------------------------------------------------------------------
-- author Ylber Hasani
--------------------------------------------------------------------------------
-- copyright Copyright (c) 2017, Austrian Institute of Technology (AIT)
--------------------------------------------------------------------------------


library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
-- use work.bsmttsPkg.all;

entity config_ttslogic is
    port (
        clk_i                     : in  std_logic;
        rst_n_i                   : in  std_logic;
        --
        avmm_clk_i                : in  std_logic;
        avmm_addr_i               : in  std_logic_vector(6  downto 0);
        avmm_data_i               : in  std_logic_vector(31 downto 0);
        avmm_chipselect_i         : in  std_logic;
        avmm_write_i              : in  std_logic;
        avmm_read_i               : in  std_logic;
        avmm_data_o               : out std_logic_vector(31 downto 0);
        -- master timing parameter
        -- tccnt_sync_o              : out std_logic_vector(31 downto 0);
        -- tccnt_load_o              : out std_logic_vector(31 downto 0);
        -- inttrig_notexttrig_o      : out std_logic_vector(31 downto 0);
        -- inttrig_start_o           : out std_logic_vector(31 downto 0);
        -- inttrig_start_edge_o      : out std_logic;
        -- inttrig_number_o          : out std_logic_vector(31 downto 0);
        -- inttrig_distance_o        : out std_logic_vector(31 downto 0);
        -- inttrig_busy_i            : in  std_logic_vector(31 downto 0);
        -- tcperiod_i                : in  std_logic_vector(31 downto 0);
        -- new_tcperiod_i            : in  std_logic;
        -- tccnt_value_i             : in  std_logic_vector(31 downto 0);
        -- tccnt_value_bntrig_i      : in  std_logic_vector(31 downto 0);
        -- tccnt_value_timerpulse_i  : in std_logic_vector(31 downto 0);
        -- --tts_gen parameter
        -- tts_config_o              : out configregArray(8 downto 0);
        -- bptrigupdate_o            : out configregArray(8 downto 0);
        -- new_bptrigupdate_edge_o   : out std_logic_vector(8 downto 0);
        -- sync_clear_fifo_o         : out std_logic_vector(31 downto 0);
        -- sync_clear_fifo_edge_o    : out std_logic;
        -- bppulsewidth_o            : out configregArray(8 downto 0);
        -- reset_out_o               : out configregArray(8 downto 0);
        -- ready_in_i                : in  configregArray(8 downto 0);
        --
        ttsready_device_o         : out std_logic;
        ttstc_period_i            : in  std_logic_vector(31 downto 0);
        new_ttstc_period_i        : in  std_logic;
        ttsbp_period_i            : in  std_logic_vector(31 downto 0);
        new_ttsbp_period_i        : in  std_logic;
        ttsbp_duration_i          : in  std_logic_vector(31 downto 0);
        new_ttsbp_duration_i      : in  std_logic;
        ttsbp_numbers_i           : in  std_logic_vector(31 downto 0);
        new_ttsbp_numbers_i       : in  std_logic;
        clear_ttsbp_numbers_o     : out std_logic;
        ttsifc_status_i           : in  std_logic_vector(31 downto 0);
        -- testmode_o                : out std_logic_vector(31 downto 0);
        --
        irq_enable_o              : out std_logic_vector(31 downto 0);
        irq_clear_o               : out std_logic_vector(31 downto 0);
        irq_clear_edge_o          : out std_logic;
        irq_set_o                 : out std_logic_vector(31 downto 0);
        irq_set_edge_o            : out std_logic;
        irq_pending_i             : in  std_logic_vector(31 downto 0)
        --
        -- global_sync_i             : in  std_logic_vector(3 downto 0);
        -- global_sync_o             : out std_logic_vector(3 downto 0);
        -- global_sync_d             : out std_logic_vector(3 downto 0);
        -- fast_sync_i               : in  std_logic_vector(2 downto 0);
        -- fast_sync_o               : out std_logic_vector(2 downto 0);
        -- fast_sync_select_o        : out std_logic_vector(1 downto 0);
        -- trigger_i                 : in  std_logic_vector(2 downto 0);
        -- --
        -- hpsdebugout_o             : out std_logic_vector(31 downto 0);
        -- hpsdebugdir_o             : out std_logic_vector(31 downto 0);
        -- hpsdebugin_i              : in  std_logic_vector(31 downto 0);
        -- hpsdebugout_select_o      : out std_logic_vector(16 downto 0);
        -- led_out_o                 : out std_logic_vector(31 downto 0);
        -- speaker_period_o          : out std_logic_vector(31 downto 0);
        -- speaker_ena_o             : out std_logic_vector(31 downto 0);
        -- switch_i                  : in  std_logic_vector(3  downto 0);
        -- tx_injecterror_numbers_o  : out std_logic_vector(31 downto 0);
        -- tx_injecterror_distance_o : out std_logic_vector(31 downto 0);
        -- tx_injecterror_edge_o     : out std_logic;
        -- rx_injecterror_numbers_o  : out std_logic_vector(31 downto 0);
        -- rx_injecterror_distance_o : out std_logic_vector(31 downto 0);
        -- rx_injecterror_edge_o     : out std_logic;

        -- soc_tcnt_o                : out std_logic_vector(31 downto 0);
        -- soc_tcnt_edge_o           : out std_logic;
        -- bptime_aftersoc_i         : in  std_logic_vector(31 downto 0);
        -- new_bptime_aftersoc_i     : in  std_logic
        );
end entity config_ttslogic;


architecture rtl of config_ttslogic is

subtype configregister is std_logic_vector(31 downto 0);
type configregArray is array (natural range <>) of configregister;

-- signal s_tccnt_sync                    : std_logic_vector(31 downto 0);
-- signal s_tccnt_load                    : std_logic_vector(31 downto 0);
-- signal s_inttrig_notexttrig            : std_logic_vector(31 downto 0);
-- signal s_inttrig_start                 : std_logic_vector(31 downto 0);
-- signal s_inttrig_number                : std_logic_vector(31 downto 0);
-- signal s_inttrig_distance              : std_logic_vector(31 downto 0);
-- signal s_inttrig_busy                  : std_logic_vector(31 downto 0);
-- signal s_inttrig_busy_temp             : std_logic_vector(31 downto 0);
-- signal s_tcperiod                      : std_logic_vector(31 downto 0);
-- signal s_tcperiod_read                 : std_logic;
-- signal s_tccnt_value                   : std_logic_vector(31 downto 0);
-- signal s_tccnt_value_temp              : std_logic_vector(31 downto 0);
-- signal s_tccnt_value_bntrig            : std_logic_vector(31 downto 0);
-- signal s_tccnt_value_bntrig_temp       : std_logic_vector(31 downto 0);
-- signal s_tccnt_value_timerpulse        : std_logic_vector(31 downto 0);
-- signal s_tccnt_value_timerpulse_temp   : std_logic_vector(31 downto 0);

-- signal s_sync_clear_fifo               : std_logic_vector(31 downto 0);
signal s_irq_enable                    : std_logic_vector(31 downto 0);
signal s_irq_clear                     : std_logic_vector(31 downto 0);
signal s_irq_pending                   : std_logic_vector(31 downto 0);
signal s_irq_pending_temp              : std_logic_vector(31 downto 0);
signal s_irq_set                       : std_logic_vector(31 downto 0);
-- signal s_hpsdebugout                   : std_logic_vector(31 downto 0);
-- signal s_hpsdebugdir                   : std_logic_vector(31 downto 0);
-- signal s_hpsdebugin                    : std_logic_vector(31 downto 0);
-- signal s_global_sync_i                 : std_logic_vector(3 downto 0);
-- signal s_global_sync_o                 : std_logic_vector(3 downto 0);
-- signal s_global_sync_d                 : std_logic_vector(3 downto 0);
-- signal s_fast_sync_i                   : std_logic_vector(2 downto 0);
-- signal s_fast_sync_o                   : std_logic_vector(2 downto 0);
-- signal s_fast_sync_select_o            : std_logic_vector(1 downto 0);
-- signal s_trigger_i                     : std_logic_vector(2 downto 0);

-- signal s_tts_config                    : configregArray(8 downto 0);
-- signal s_bptrigupdate                  : configregArray(8 downto 0);
-- signal s_bppulsewidth                  : configregArray(8 downto 0);
-- signal s_resetout                      : configregArray(8 downto 0);
-- signal s_readyin                       : configregArray(8 downto 0);
-- signal s_readyin_temp                  : configregArray(8 downto 0);

signal s_avmm_addr                     : std_logic_vector(6 downto 0);
signal s_avmm_data                     : std_logic_vector(31 downto 0);
signal s_avmm_chipselect               : std_logic;
signal s_avmm_write                    : std_logic;
signal s_avmm_read                     : std_logic;

-- signal s_freeze_inttrigbusy            : std_logic;
-- signal s_freeze_tccnt_value            : std_logic;
-- signal s_freeze_readyin                : std_logic_vector(8 downto 0);
signal s_freeze_irq_pending            : std_logic;
-- signal s_freeze_tccnt_value_bntrig     : std_logic;
-- signal s_freeze_tccnt_value_timerpulse : std_logic;
-- signal s_freeze_switch                 : std_logic;
-- signal s_freeze_hpsdebugin             : std_logic;
-- signal s_freeze_global_sync_i          : std_logic;
-- signal s_freeze_fast_sync_i            : std_logic;
-- signal s_freeze_trigger_i              : std_logic;

signal s_ttstc_period                  : std_logic_vector(31 downto 0);
signal s_ttsbp_period                  : std_logic_vector(31 downto 0);
signal s_ttsbp_duration                : std_logic_vector(31 downto 0);
signal s_ttsbp_numbers                 : std_logic_vector(31 downto 0);

signal s_ttstc_period_read             : std_logic;
signal s_ttsbp_period_read             : std_logic;
signal s_ttsbp_duration_read           : std_logic;
signal s_ttsbp_numbers_read            : std_logic;

-- signal s_testmode                      : std_logic_vector(31 downto 0);
-- signal s_led_out                       : std_logic_vector(31 downto 0);
-- signal s_speaker_period                : std_logic_vector(31 downto 0);
-- signal s_speaker_ena                   : std_logic_vector(31 downto 0);
-- signal s_switch                        : std_logic_vector(31 downto 0);
-- signal s_switch_temp                   : std_logic_vector(31 downto 0);
-- signal s_hpsdebugin_temp               : std_logic_vector(31 downto 0);
-- signal s_global_sync_i_temp            : std_logic_vector(3  downto 0);
-- signal s_fast_sync_i_temp              : std_logic_vector(2  downto 0);
-- signal s_trigger_i_temp                : std_logic_vector(2  downto 0);

signal s_ttsready_device               : std_logic_vector(31 downto 0);

-- signal s_tx_injecterror_numbers        : std_logic_vector(31 downto 0);
-- signal s_tx_injecterror_distance       : std_logic_vector(31 downto 0);
-- signal s_rx_injecterror_numbers        : std_logic_vector(31 downto 0);
-- signal s_rx_injecterror_distance       : std_logic_vector(31 downto 0);

-- signal s_hpsdebugout_select            : std_logic_vector(16 downto 0);

-- signal s_soc_tcnt                      : std_logic_vector(31 downto 0);
-- signal s_bptime_aftersoc               : std_logic_vector(31 downto 0);
-- signal s_bptime_aftersoc_read          : std_logic;

begin

  -- tccnt_sync_o         <= s_tccnt_sync;
  -- tccnt_load_o         <= s_tccnt_load;
  -- inttrig_notexttrig_o <= s_inttrig_notexttrig;
  -- inttrig_start_o      <= s_inttrig_start;
  -- inttrig_number_o     <= s_inttrig_number;
  -- inttrig_distance_o   <= s_inttrig_distance;
  -- sync_clear_fifo_o    <= s_sync_clear_fifo;
  -- tts_config_o         <= s_tts_config;
  -- bptrigupdate_o       <= s_bptrigupdate;
  -- bppulsewidth_o       <= s_bppulsewidth;
  -- reset_out_o          <= s_resetout;
  irq_enable_o         <= s_irq_enable;
  irq_clear_o          <= s_irq_clear;
  irq_set_o            <= s_irq_set;
  -- hpsdebugout_o        <= s_hpsdebugout;
  -- hpsdebugdir_o        <= s_hpsdebugdir;
  -- hpsdebugout_select_o <= s_hpsdebugout_select;
  -- global_sync_o        <= s_global_sync_o;
  -- global_sync_d        <= s_global_sync_d;
  -- fast_sync_o          <= s_fast_sync_o;
  -- fast_sync_select_o   <= s_fast_sync_select_o;
  -- testmode_o           <= s_testmode;
  -- led_out_o            <= s_led_out;
  -- speaker_period_o     <= s_speaker_period;
  -- speaker_ena_o        <= s_speaker_ena;
  ttsready_device_o    <= s_ttsready_device(0);
  -- tx_injecterror_numbers_o  <= s_tx_injecterror_numbers;
  -- tx_injecterror_distance_o <= s_tx_injecterror_distance;
  -- rx_injecterror_numbers_o  <= s_rx_injecterror_numbers;
  -- rx_injecterror_distance_o <= s_rx_injecterror_distance;
  -- soc_tcnt_o                <= s_soc_tcnt;

  p_reset_after_read_and_sample_new_values: process (clk_i,rst_n_i) is
  begin
    if (rst_n_i = '0') then

        s_ttstc_period    <= (others => '1');
        s_ttsbp_period    <= (others => '1');
        s_ttsbp_duration  <= (others => '1');
        s_ttsbp_numbers   <= (others => '1');
        -- s_tcperiod        <= (others => '1');
        -- s_bptime_aftersoc <= (others => '1');

    elsif (rising_edge(clk_i)) then

        -- set after read to X"FFFF_FFFF"
        if (s_ttstc_period_read = '1') then
            s_ttstc_period <= (others => '1');
        end if;

        if (s_ttsbp_period_read = '1') then
            s_ttsbp_period <= (others => '1');
        end if;

        if (s_ttsbp_duration_read = '1') then
            s_ttsbp_duration <= (others => '1');
        end if;

        if (s_ttsbp_numbers_read = '1') then
            s_ttsbp_numbers <= (others => '1');
        end if;

        -- if (s_tcperiod_read = '1') then
            -- s_tcperiod <= (others => '1');
        -- end if;

        -- if (s_bptime_aftersoc_read = '1') then
            -- s_bptime_aftersoc <= (others => '1');
        -- end if;

        -- take new value
        if (new_ttstc_period_i = '1') then
            s_ttstc_period <= ttstc_period_i;
        end if;

        if (new_ttsbp_period_i = '1') then
            s_ttsbp_period <= ttsbp_period_i;
        end if;

        if (new_ttsbp_duration_i = '1') then
            s_ttsbp_duration <= ttsbp_duration_i;
        end if;

        if (new_ttsbp_numbers_i = '1') then
            s_ttsbp_numbers <= ttsbp_numbers_i;
        end if;

        -- if (new_tcperiod_i = '1') then
            -- s_tcperiod <= tcperiod_i;
        -- end if;

        -- if (new_bptime_aftersoc_i = '1') then
            -- s_bptime_aftersoc <= bptime_aftersoc_i;
        -- end if;

    end if;
  end process p_reset_after_read_and_sample_new_values;



  p_freeze_registers_while_read: process (clk_i,rst_n_i) is
  begin
    if (rst_n_i = '0') then

        -- s_inttrig_busy <= (others => '0');
        -- s_inttrig_busy_temp <= (others => '0');
        -- s_tccnt_value <= (others => '0');
        -- s_tccnt_value_temp <= (others => '0');
        -- s_readyin <= ((others => (others => '0')));
        -- s_readyin_temp <= ((others => (others => '0')));
        s_irq_pending <= (others => '0');
        s_irq_pending_temp <= (others => '0');
        -- s_tccnt_value_bntrig <= (others => '0');
        -- s_tccnt_value_bntrig_temp <= (others => '0');
        -- s_tccnt_value_timerpulse <= (others => '0');
        -- s_tccnt_value_timerpulse_temp <= (others => '0');
        -- s_switch <= (others => '0');
        -- s_switch_temp <= (others => '0');
        -- s_hpsdebugin <= (others => '0');
        -- s_hpsdebugin_temp <= (others => '0');
        -- s_global_sync_i_temp <= (others => '0');
        -- s_fast_sync_i_temp <= (others => '0');
        -- s_trigger_i_temp <= (others => '0');
    elsif (rising_edge(clk_i)) then

        -- s_inttrig_busy_temp <= inttrig_busy_i;
        -- s_tccnt_value_temp <= tccnt_value_i;
        -- s_readyin_temp <= ready_in_i;
        s_irq_pending_temp <= irq_pending_i;
        -- s_tccnt_value_bntrig_temp <= tccnt_value_bntrig_i;
        -- s_tccnt_value_timerpulse_temp <=  tccnt_value_timerpulse_i;
        -- s_switch_temp <= X"0000000" & switch_i;
        -- s_hpsdebugin_temp <= hpsdebugin_i;
        -- s_global_sync_i_temp <= global_sync_i;
        -- s_fast_sync_i_temp <= fast_sync_i;
        -- s_trigger_i_temp <= trigger_i;

        -- if (s_freeze_inttrigbusy = '0') then
            -- s_inttrig_busy <= s_inttrig_busy_temp;
        -- end if;

        -- if (s_freeze_tccnt_value = '0') then
            -- s_tccnt_value <= s_tccnt_value_temp;
        -- end if;

        -- for i in 0 to 8 loop
            -- if (s_freeze_readyin(i) = '0') then
                -- s_readyin(i) <= s_readyin_temp(i);
            -- end if;
        -- end loop;

        if (s_freeze_irq_pending = '0') then
            s_irq_pending <= s_irq_pending_temp;
        end if;

        -- if (s_freeze_tccnt_value_bntrig = '0') then
            -- s_tccnt_value_bntrig <= s_tccnt_value_bntrig_temp;
        -- end if;

        -- if (s_freeze_tccnt_value_timerpulse = '0') then
            -- s_tccnt_value_timerpulse <= s_tccnt_value_timerpulse_temp;
        -- end if;

        -- if (s_freeze_switch = '0') then
            -- s_switch <= s_switch_temp;
        -- end if;

        -- if (s_freeze_hpsdebugin = '0') then
            -- s_hpsdebugin <= s_hpsdebugin_temp;
        -- end if;

        -- if (s_freeze_global_sync_i = '0') then
            -- s_global_sync_i <= s_global_sync_i_temp;
        -- end if;

        -- if (s_freeze_fast_sync_i = '0') then
            -- s_fast_sync_i <= s_fast_sync_i_temp;
        -- end if;

        -- if (s_freeze_trigger_i = '0') then
            -- s_trigger_i <= s_trigger_i_temp;
        -- end if;
    end if;
  end process p_freeze_registers_while_read;


  p_avalon_cfg_ifc : process (avmm_clk_i, rst_n_i)
  begin
    if (rst_n_i = '0') then

        -- s_tccnt_sync                    <= (others => '0');
        -- s_tccnt_load                    <= (others => '0');
        -- s_inttrig_notexttrig            <= (others => '0');
        -- s_inttrig_start                 <= (others => '0');
        -- inttrig_start_edge_o            <= '0';
        -- s_inttrig_number                <= (others => '0');
        -- s_inttrig_distance              <= (others => '0');

        -- s_sync_clear_fifo               <= (others => '0');
        -- sync_clear_fifo_edge_o          <= '0';
        -- s_tts_config                    <= ((others => (others => '0')));
        -- s_bptrigupdate                  <= ((others => (others => '0')));
        -- s_bppulsewidth                  <= ((others => (others => '0')));
        -- s_resetout                      <= ((others => (others => '0')));

        s_irq_enable                    <= (others => '0');
        s_irq_clear                     <= (others => '0');
        irq_clear_edge_o                <= '0';
        s_irq_set                       <= (others => '0');
        irq_set_edge_o                  <= '0';
        -- s_hpsdebugout                   <= (others => '0');
        -- s_hpsdebugdir                   <= (others => '1');
        -- s_hpsdebugout_select            <= (others => '0');
        -- s_soc_tcnt                      <= (others => '0');
        -- soc_tcnt_edge_o                 <= '0';
        -- s_global_sync_o                 <= (others => '0');
        -- s_global_sync_d                 <= (others => '0');
        -- s_fast_sync_o                   <= (others => '0');
        -- s_fast_sync_select_o            <= (others => '0');

        -- s_testmode                      <= (others => '0');
        -- s_led_out                       <= (others => '0');
        -- s_speaker_period                <= x"0001BBE4";
        -- s_speaker_ena                   <= (others => '0');

        -- s_freeze_inttrigbusy            <= '0';
        -- s_tcperiod_read                 <= '0';
        -- s_freeze_tccnt_value            <= '0';
        -- s_freeze_readyin                <= (others => '0');
        s_freeze_irq_pending            <= '0';
        -- s_freeze_tccnt_value_bntrig     <= '0';
        -- s_freeze_tccnt_value_timerpulse <= '0';
        -- s_freeze_switch                 <= '0';

        s_ttstc_period_read             <= '0';
        s_ttsbp_period_read             <= '0';
        s_ttsbp_duration_read           <= '0';
        s_ttsbp_numbers_read            <= '0';
        clear_ttsbp_numbers_o           <= '0';

        -- s_bptime_aftersoc_read          <= '0';

        -- s_tx_injecterror_numbers        <= (others => '0');
        -- tx_injecterror_edge_o           <= '0';
        -- s_tx_injecterror_distance       <= (others => '0');
        -- s_rx_injecterror_numbers        <= (others => '0');
        -- rx_injecterror_edge_o           <= '0';
        -- s_rx_injecterror_distance       <= (others => '0');

        s_avmm_addr                     <= (others => '0');
        s_avmm_data                     <= (others => '0');
        s_avmm_chipselect               <= '0';
        s_avmm_write                    <= '0';
        s_avmm_read                     <= '0';
        avmm_data_o                     <= (others => '0');

    elsif rising_edge(avmm_clk_i) then

        -- inttrig_start_edge_o    <= '0';
        irq_clear_edge_o        <= '0';
        irq_set_edge_o          <= '0';
        -- new_bptrigupdate_edge_o <= (others => '0');
        -- sync_clear_fifo_edge_o  <= '0';
        -- tx_injecterror_edge_o   <= '0';
        -- rx_injecterror_edge_o   <= '0';
        -- soc_tcnt_edge_o         <= '0';

        s_avmm_addr          <= avmm_addr_i;
        s_avmm_data          <= avmm_data_i;
        s_avmm_chipselect    <= avmm_chipselect_i;
        s_avmm_write         <= avmm_write_i;
        s_avmm_read          <= avmm_read_i;

        if (s_avmm_chipselect = '1') then
            -- write
            if (s_avmm_write = '1') then
                case s_avmm_addr is
                -- when "0000000" =>
                  -- s_tccnt_sync <= s_avmm_data;
                -- when "0000001" =>
                  -- s_tccnt_load <= s_avmm_data;
                -- when "0000010" =>
                  -- s_inttrig_notexttrig <= s_avmm_data;
                -- when "0000011" =>
                  -- s_inttrig_start <= s_avmm_data;
                  -- inttrig_start_edge_o <= '1';
                -- when "0000100" =>
                  -- s_inttrig_number <= s_avmm_data;
                -- when "0000101" =>
                  -- s_inttrig_distance <= s_avmm_data;
                -- -- read when "0000110" =>
                -- -- read when "0000111" =>
                -- -- read when "0001000" =>

                -- when "0001001" =>
                  -- s_sync_clear_fifo  <= s_avmm_data;
                  -- sync_clear_fifo_edge_o <= '1';
                -- when "0001010" =>
                  -- s_tts_config(0) <= s_avmm_data;
                -- when "0001011" =>
                  -- s_bptrigupdate(0) <= s_avmm_data;
                  -- new_bptrigupdate_edge_o(0) <= '1';
                -- when "0001100" =>
                  -- s_bppulsewidth(0) <= s_avmm_data;
                -- when "0001101" =>
                  -- s_resetout(0) <= s_avmm_data;
                -- -- read when "0001110" =>

                -- when "0001111" =>
                  -- s_tts_config(1) <= s_avmm_data;
                -- when "0010000" =>
                  -- s_bptrigupdate(1) <= s_avmm_data;
                  -- new_bptrigupdate_edge_o(1) <= '1';
                -- when "0010001" =>
                  -- s_bppulsewidth(1) <= s_avmm_data;
                -- when "0010010" =>
                  -- s_resetout(1) <= s_avmm_data;
                -- -- read when "0010011" =>

                -- when "0010100" =>
                  -- s_tts_config(2) <= s_avmm_data;
                -- when "0010101" =>
                  -- s_bptrigupdate(2) <= s_avmm_data;
                  -- new_bptrigupdate_edge_o(2) <= '1';
                -- when "0010110" =>
                  -- s_bppulsewidth(2) <= s_avmm_data;
                -- when "0010111" =>
                  -- s_resetout(2) <= s_avmm_data;
                -- -- read when "0011000" =>

                -- when "0011001" =>
                  -- s_tts_config(3) <= s_avmm_data;
                -- when "0011010" =>
                  -- s_bptrigupdate(3) <= s_avmm_data;
                  -- new_bptrigupdate_edge_o(3) <= '1';
                -- when "0011011" =>
                  -- s_bppulsewidth(3) <= s_avmm_data;
                -- when "0011100" =>
                  -- s_resetout(3) <= s_avmm_data;
                -- -- read when "0011101" =>

                -- when "0011110" =>
                  -- s_tts_config(4) <= s_avmm_data;
                -- when "0011111" =>
                  -- s_bptrigupdate(4) <= s_avmm_data;
                  -- new_bptrigupdate_edge_o(4) <= '1';
                -- when "0100000" =>
                  -- s_bppulsewidth(4) <= s_avmm_data;
                -- when "0100001" =>
                  -- s_resetout(4) <= s_avmm_data;
                -- -- read when "0100010" =>

                -- when "0100011" =>
                  -- s_tts_config(5) <= s_avmm_data;
                -- when "0100100" =>
                  -- s_bptrigupdate(5) <= s_avmm_data;
                  -- new_bptrigupdate_edge_o(5) <= '1';
                -- when "0100101" =>
                  -- s_bppulsewidth(5) <= s_avmm_data;
                -- when "0100110" =>
                  -- s_resetout(5) <= s_avmm_data;
                -- -- read when "0100111" =>

                -- when "0101000" =>
                  -- s_tts_config(6) <= s_avmm_data;
                -- when "0101001" =>
                  -- s_bptrigupdate(6) <= s_avmm_data;
                  -- new_bptrigupdate_edge_o(6) <= '1';
                -- when "0101010" =>
                  -- s_bppulsewidth(6) <= s_avmm_data;
                -- when "0101011" =>
                  -- s_resetout(6) <= s_avmm_data;
                -- -- read when "0101100" =>

                -- when "0101101" =>
                  -- s_tts_config(7) <= s_avmm_data;
                -- when "0101110" =>
                  -- s_bptrigupdate(7) <= s_avmm_data;
                  -- new_bptrigupdate_edge_o(7) <= '1';
                -- when "0101111" =>
                  -- s_bppulsewidth(7) <= s_avmm_data;
                -- when "0110000" =>
                  -- s_resetout(7) <= s_avmm_data;
                -- -- read when "0110001" =>

                -- when "0110010" =>
                  -- s_tts_config(8) <= s_avmm_data;
                -- when "0110011" =>
                  -- s_bptrigupdate(8) <= s_avmm_data;
                  -- new_bptrigupdate_edge_o(8) <= '1';
                -- when "0110100" =>
                  -- s_bppulsewidth(8) <= s_avmm_data;
                -- when "0110101" =>
                  -- s_resetout(8) <= s_avmm_data;
                -- -- read when "0110110" =>
                when "0110111" =>
                  s_irq_enable <= s_avmm_data;
                when "0111000" =>
                  s_irq_clear <= s_avmm_data;
                  irq_clear_edge_o <= '1';
                -- read when "0111001" =>
                when "0111010" =>
                  s_irq_set <= s_avmm_data;
                  irq_set_edge_o <= '1';
                -- when "0111011" =>
                  -- s_hpsdebugout <= s_avmm_data;
                -- -- read when 0111100 to 1000010
                -- when "1000011" =>
                   -- s_testmode <= s_avmm_data;
                -- when "1000100" =>
                   -- s_led_out  <= s_avmm_data;
                -- when "1000101" =>
                   -- s_speaker_ena  <= s_avmm_data;
                -- --read  when "1000110" =>
                when "1000111" =>
                   s_ttsready_device <= s_avmm_data;
                -- when "1001000" =>
                  -- s_hpsdebugdir <= s_avmm_data;
                -- -- read when "1001001"
                -- when "1001010" =>
                   -- s_global_sync_o <= s_avmm_data(s_global_sync_o'range);
                -- when "1001011" =>
                   -- s_global_sync_d <= s_avmm_data(s_global_sync_d'range);
                -- -- read when "1001100"
                -- when "1001101" =>
                   -- s_fast_sync_o <= s_avmm_data(2 downto 0);
                   -- s_fast_sync_select_o <= s_avmm_data(9 downto 8);
                -- -- read when "1001110"
                -- when "1001111" =>
                   -- s_speaker_period <= s_avmm_data;
                -- when "1010000" =>
                   -- s_tx_injecterror_distance <= s_avmm_data(tx_injecterror_distance_o'range);
                -- when "1010001" =>
                   -- s_tx_injecterror_numbers <= s_avmm_data(tx_injecterror_numbers_o'range);
                   -- tx_injecterror_edge_o <= '1';
                -- when "1010010" =>
                   -- s_rx_injecterror_distance <= s_avmm_data(rx_injecterror_distance_o'range);
                -- when "1010011" =>
                   -- s_rx_injecterror_numbers <= s_avmm_data(rx_injecterror_numbers_o'range);
                   -- rx_injecterror_edge_o <= '1';
                -- -- read when "1010100"
                -- when "1010101" =>
                   -- s_hpsdebugout_select <= s_avmm_data(hpsdebugout_select_o'range);
                -- when "1010110" =>
                   -- s_soc_tcnt <= s_avmm_data(soc_tcnt_o'range);
                   -- soc_tcnt_edge_o <= '1';
                -- -- read when "1010111"
                when others =>

                end case;
            end if;
        end if;

        -- s_freeze_inttrigbusy            <= '0';
        -- s_tcperiod_read                 <= '0';
        -- s_freeze_tccnt_value            <= '0';
        -- s_freeze_readyin                <= (others => '0');
        s_freeze_irq_pending            <= '0';
        -- s_freeze_tccnt_value_bntrig     <= '0';
        -- s_freeze_tccnt_value_timerpulse <= '0';
        -- s_freeze_switch                 <= '0';
        -- s_freeze_hpsdebugin             <= '0';
        -- s_freeze_global_sync_i          <= '0';
        -- s_freeze_fast_sync_i            <= '0';
        -- s_freeze_trigger_i              <= '0';

        s_ttstc_period_read             <= '0';
        s_ttsbp_period_read             <= '0';
        s_ttsbp_duration_read           <= '0';
        s_ttsbp_numbers_read            <= '0';

        clear_ttsbp_numbers_o           <= '0';

        -- s_bptime_aftersoc_read          <= '0';


        avmm_data_o                     <= (others => '0');

        if (s_avmm_chipselect = '1') then
            -- read
            if (s_avmm_read = '1') then
                case s_avmm_addr is
                -- when "0000000" =>
                  -- avmm_data_o <= s_tccnt_sync;
                -- when "0000001" =>
                  -- avmm_data_o <= s_tccnt_load;
                -- when "0000010" =>
                  -- avmm_data_o <= s_inttrig_notexttrig;
                -- when "0000011" =>
                  -- avmm_data_o <= s_inttrig_start;
                -- when "0000100" =>
                  -- avmm_data_o <= s_inttrig_number;
                -- when "0000101" =>
                  -- avmm_data_o <= s_inttrig_distance;
                -- when "0000110" =>
                  -- avmm_data_o <= s_inttrig_busy;
                  -- s_freeze_inttrigbusy <= '1';
                -- when "0000111" =>
                  -- avmm_data_o <= s_tccnt_value;
                  -- s_freeze_tccnt_value <= '1';
                -- when "0001000" =>
                  -- avmm_data_o <= s_tcperiod;
                  -- s_tcperiod_read <= '1';
                -- when "0001001" =>
                  -- avmm_data_o <= s_sync_clear_fifo;
                -- when "0001010" =>
                  -- avmm_data_o <= s_tts_config(0);
                -- when "0001011" =>
                  -- avmm_data_o <= s_bptrigupdate(0);
                -- when "0001100" =>
                  -- avmm_data_o <= s_bppulsewidth(0);
                -- when "0001101" =>
                  -- avmm_data_o <= s_resetout(0);
                -- when "0001110" =>
                  -- avmm_data_o <= s_readyin(0);
                  -- s_freeze_readyin(0) <= '1';
                -- when "0001111" =>
                  -- avmm_data_o <= s_tts_config(1);
                -- when "0010000" =>
                  -- avmm_data_o <= s_bptrigupdate(1);
                -- when "0010001" =>
                  -- avmm_data_o <= s_bppulsewidth(1);
                -- when "0010010" =>
                  -- avmm_data_o <= s_resetout(1);
                -- when "0010011" =>
                  -- avmm_data_o <= s_readyin(1);
                  -- s_freeze_readyin(1) <= '1';
                -- when "0010100" =>
                  -- avmm_data_o <= s_tts_config(2);
                -- when "0010101" =>
                  -- avmm_data_o <= s_bptrigupdate(2);
                -- when "0010110" =>
                  -- avmm_data_o <= s_bppulsewidth(2);
                -- when "0010111" =>
                  -- avmm_data_o <= s_resetout(2);
                -- when "0011000" =>
                  -- avmm_data_o <= s_readyin(2);
                  -- s_freeze_readyin(2) <= '1';
                -- when "0011001" =>
                  -- avmm_data_o <= s_tts_config(3);
                -- when "0011010" =>
                  -- avmm_data_o <= s_bptrigupdate(3);
                -- when "0011011" =>
                  -- avmm_data_o <= s_bppulsewidth(3);
                -- when "0011100" =>
                  -- avmm_data_o <= s_resetout(3);
                -- when "0011101" =>
                  -- avmm_data_o <= s_readyin(3);
                  -- s_freeze_readyin(3) <= '1';
                -- when "0011110" =>
                  -- avmm_data_o <= s_tts_config(4);
                -- when "0011111" =>
                  -- avmm_data_o <= s_bptrigupdate(4);
                -- when "0100000" =>
                  -- avmm_data_o <= s_bppulsewidth(4);
                -- when "0100001" =>
                  -- avmm_data_o <= s_resetout(4);
                -- when "0100010" =>
                  -- avmm_data_o <= s_readyin(4);
                  -- s_freeze_readyin(4) <= '1';
                -- when "0100011" =>
                  -- avmm_data_o <= s_tts_config(5);
                -- when "0100100" =>
                  -- avmm_data_o <= s_bptrigupdate(5);
                -- when "0100101" =>
                  -- avmm_data_o <= s_bppulsewidth(5);
                -- when "0100110" =>
                  -- avmm_data_o <= s_resetout(5);
                -- when "0100111" =>
                  -- avmm_data_o <= s_readyin(5);
                  -- s_freeze_readyin(5) <= '1';
                -- when "0101000" =>
                  -- avmm_data_o <= s_tts_config(6);
                -- when "0101001" =>
                  -- avmm_data_o <= s_bptrigupdate(6);
                -- when "0101010" =>
                  -- avmm_data_o <= s_bppulsewidth(6);
                -- when "0101011" =>
                  -- avmm_data_o <= s_resetout(6);
                -- when "0101100" =>
                  -- avmm_data_o <= s_readyin(6);
                  -- s_freeze_readyin(6) <= '1';
                -- when "0101101" =>
                  -- avmm_data_o <= s_tts_config(7);
                -- when "0101110" =>
                  -- avmm_data_o <= s_bptrigupdate(7);
                -- when "0101111" =>
                  -- avmm_data_o <= s_bppulsewidth(7);
                -- when "0110000" =>
                  -- avmm_data_o <= s_resetout(7);
                -- when "0110001" =>
                  -- avmm_data_o <= s_readyin(7);
                  -- s_freeze_readyin(7) <= '1';
                -- when "0110010" =>
                  -- avmm_data_o <= s_tts_config(8);
                -- when "0110011" =>
                  -- avmm_data_o <= s_bptrigupdate(8);
                -- when "0110100" =>
                  -- avmm_data_o <= s_bppulsewidth(8);
                -- when "0110101" =>
                  -- avmm_data_o <= s_resetout(8);
                -- when "0110110" =>
                  -- avmm_data_o <= s_readyin(8);
                  -- s_freeze_readyin(8) <= '1';
                when "0110111" =>
                  avmm_data_o <= s_irq_enable;
                when "0111000" =>
                  avmm_data_o <= s_irq_clear;
                when "0111001" =>
                  avmm_data_o <= s_irq_pending;
                  s_freeze_irq_pending <= '1';
                when "0111010" =>
                  avmm_data_o <= s_irq_set;
                -- when "0111011" =>
                  -- avmm_data_o <= s_hpsdebugout;
                -- when "0111100" =>
                  -- avmm_data_o <= s_tccnt_value_bntrig;
                  -- s_freeze_tccnt_value_bntrig <= '1';
                -- when "0111101" =>
                  -- avmm_data_o <= s_tccnt_value_timerpulse;
                  -- s_freeze_tccnt_value_timerpulse <= '1';
                when "0111110" =>
                  avmm_data_o <= s_ttstc_period;
                  s_ttstc_period_read <= '1';
                when "0111111" =>
                  avmm_data_o <= s_ttsbp_period;
                  s_ttsbp_period_read <= '1';
                when "1000000" =>
                  avmm_data_o <= s_ttsbp_duration;
                  s_ttsbp_duration_read <= '1';
                when "1000001" =>
                  avmm_data_o <= s_ttsbp_numbers;
                  s_ttsbp_numbers_read <= '1';
                  clear_ttsbp_numbers_o <= '1';
                when "1000010" =>
                  avmm_data_o <= ttsifc_status_i;
                -- when "1000011" =>
                  -- avmm_data_o <= s_testmode;
                -- when "1000100" =>
                  -- avmm_data_o <= s_led_out;
                -- when "1000101" =>
                  -- avmm_data_o <= s_speaker_ena;
                -- when "1000110" =>
                  -- for i in switch_i'low to switch_i'high loop
                    -- avmm_data_o(switch_i'high - i) <= not s_switch(i);
                  -- end loop;
                  -- s_freeze_switch <= '1';
                when "1000111" =>
                   avmm_data_o <= s_ttsready_device;
                -- when "1001000" =>
                  -- avmm_data_o <= s_hpsdebugdir;
                -- when "1001001"=>
                  -- avmm_data_o <= s_hpsdebugin;
                  -- s_freeze_hpsdebugin <= '1';
                -- when "1001010" =>
                  -- avmm_data_o(s_global_sync_o'range) <= s_global_sync_o;
                -- when "1001011" =>
                  -- avmm_data_o(s_global_sync_d'range) <= s_global_sync_d;
                -- when "1001100" =>
                  -- avmm_data_o(s_global_sync_i'range) <= s_global_sync_i;
                  -- s_freeze_global_sync_i <= '1';
                -- when "1001101" =>
                  -- avmm_data_o(2 downto 0) <= s_fast_sync_o;
                  -- avmm_data_o(9 downto 8) <= s_fast_sync_select_o;
                -- when "1001110" =>
                  -- avmm_data_o(s_fast_sync_i'range) <= s_fast_sync_i;
                  -- s_freeze_fast_sync_i <= '1';
                -- when "1001111" =>
                  -- avmm_data_o <= s_speaker_period;
                -- when "1010000" =>
                  -- avmm_data_o(s_tx_injecterror_distance'range) <= s_tx_injecterror_distance;
                -- when "1010001" =>
                  -- avmm_data_o(s_tx_injecterror_numbers'range) <= s_tx_injecterror_numbers;
                -- when "1010010" =>
                  -- avmm_data_o(s_rx_injecterror_distance'range) <= s_rx_injecterror_distance;
                -- when "1010011" =>
                  -- avmm_data_o(s_rx_injecterror_numbers'range) <= s_rx_injecterror_numbers;
                -- when "1010100" =>
                  -- avmm_data_o(s_trigger_i'range) <= s_trigger_i;
                  -- s_freeze_trigger_i <= '1';
                -- when "1010101" =>
                  -- avmm_data_o(s_hpsdebugout_select'range) <= s_hpsdebugout_select;
                -- when "1010110" =>
                  -- avmm_data_o(s_soc_tcnt'range) <= s_soc_tcnt;
                -- when "1010111" =>
                  -- avmm_data_o(s_bptime_aftersoc'range) <= s_bptime_aftersoc;
                  -- s_bptime_aftersoc_read <= '1';
                when others =>

                end case;
            end if;
        end if;

    end if;
  end process p_avalon_cfg_ifc;

end rtl;
